/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgq;
import com.google.android.gms.location.ActivityTransitionEvent;
import com.google.android.gms.location.zzg;
import java.util.Collections;
import java.util.List;

public class ActivityTransitionResult
extends zzbgl {
    public static final Parcelable.Creator<ActivityTransitionResult> CREATOR = new zzg();
    private final List<ActivityTransitionEvent> zzirb;

    public ActivityTransitionResult(List<ActivityTransitionEvent> list) {
        zzbq.checkNotNull(list, (Object)"transitionEvents list can't be null.");
        List<ActivityTransitionEvent> list2 = list;
        if (!list2.isEmpty()) {
            for (int i = 1; i < list2.size(); ++i) {
                zzbq.checkArgument((list2.get(i).getElapsedRealTimeNanos() >= list2.get(i - 1).getElapsedRealTimeNanos() ? 1 : 0) != 0);
            }
        }
        this.zzirb = Collections.unmodifiableList(list);
    }

    public List<ActivityTransitionEvent> getTransitionEvents() {
        return this.zzirb;
    }

    public static boolean hasResult(@Nullable Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_RESULT");
    }

    @Nullable
    public static ActivityTransitionResult extractResult(Intent intent) {
        if (!ActivityTransitionResult.hasResult(intent)) {
            return null;
        }
        return (ActivityTransitionResult)zzbgq.zza((Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_RESULT", CREATOR);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityTransitionResult activityTransitionResult = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, activityTransitionResult.getTransitionEvents(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        return this.zzirb.equals(((ActivityTransitionResult)((Object)object)).zzirb);
    }

    public int hashCode() {
        return this.zzirb.hashCode();
    }
}

