/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import com.google.android.gms.internal.zzchp;
import com.google.android.gms.location.Geofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int mErrorCode;
    private final int zzirw;
    private final List<Geofence> zzirx;
    private final Location zziry;

    private GeofencingEvent(int n, int n2, List<Geofence> list, Location location) {
        this.mErrorCode = n;
        this.zzirw = n2;
        this.zzirx = list;
        this.zziry = location;
    }

    public static GeofencingEvent fromIntent(Intent intent) {
        ArrayList<zzchp> arrayList;
        if (intent == null) {
            return null;
        }
        int n = intent.getIntExtra("gms_error_code", -1);
        int n2 = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        int n3 = n2 != -1 && (n2 == 1 || n2 == 2 || n2 == 4) ? n2 : -1;
        ArrayList arrayList2 = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList2 == null) {
            arrayList = null;
        } else {
            ArrayList<zzchp> arrayList3 = new ArrayList<zzchp>(arrayList2.size());
            ArrayList arrayList4 = arrayList2;
            int n4 = arrayList4.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList4.get(i);
                byte[] byArray = (byte[])e;
                arrayList3.add(zzchp.zzq(byArray));
            }
            arrayList = arrayList3;
        }
        ArrayList<zzchp> arrayList5 = arrayList;
        Location location = (Location)intent.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        return new GeofencingEvent(n, n3, arrayList5, location);
    }

    public boolean hasError() {
        return this.mErrorCode != -1;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public int getGeofenceTransition() {
        return this.zzirw;
    }

    public List<Geofence> getTriggeringGeofences() {
        return this.zzirx;
    }

    public Location getTriggeringLocation() {
        return this.zziry;
    }
}

