/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.location.zzab;
import java.util.Arrays;

public final class LocationRequest
extends zzbgl
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private int mPriority;
    private long zzisg;
    private long zzish;
    private boolean zzisi;
    private long zzirp;
    private int zzirl;
    private float zzisj;
    private long zzisk;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzab();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    @Hide
    public LocationRequest() {
        this.mPriority = 102;
        this.zzisg = 3600000L;
        this.zzish = 600000L;
        this.zzisi = false;
        this.zzirp = Long.MAX_VALUE;
        this.zzirl = Integer.MAX_VALUE;
        this.zzisj = 0.0f;
        this.zzisk = 0L;
    }

    public final LocationRequest setPriority(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
        this.mPriority = n;
        return this;
    }

    public final int getPriority() {
        return this.mPriority;
    }

    public final LocationRequest setInterval(long l) {
        LocationRequest.zzai(l);
        this.zzisg = l;
        if (!this.zzisi) {
            this.zzish = (long)((double)this.zzisg / 6.0);
        }
        return this;
    }

    public final long getInterval() {
        return this.zzisg;
    }

    public final LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzai(l);
        this.zzisk = l;
        return this;
    }

    public final long getMaxWaitTime() {
        long l = this.zzisk;
        if (l < this.zzisg) {
            l = this.zzisg;
        }
        return l;
    }

    public final LocationRequest setFastestInterval(long l) {
        LocationRequest.zzai(l);
        this.zzisi = true;
        this.zzish = l;
        return this;
    }

    public final long getFastestInterval() {
        return this.zzish;
    }

    public final boolean isFastestIntervalExplicitlySet() {
        return this.zzisi;
    }

    public final LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zzirp = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zzirp < 0L) {
            this.zzirp = 0L;
        }
        return this;
    }

    public final LocationRequest setExpirationTime(long l) {
        this.zzirp = l;
        if (this.zzirp < 0L) {
            this.zzirp = 0L;
        }
        return this;
    }

    public final long getExpirationTime() {
        return this.zzirp;
    }

    public final LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzirl = n;
        return this;
    }

    public final int getNumUpdates() {
        return this.zzirl;
    }

    public final LocationRequest setSmallestDisplacement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
        this.zzisj = f;
        return this;
    }

    public final float getSmallestDisplacement() {
        return this.zzisj;
    }

    private static void zzai(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    @Hide
    LocationRequest(int n, long l, long l2, boolean bl, long l3, int n2, float f, long l4) {
        this.mPriority = n;
        this.zzisg = l;
        this.zzish = l2;
        this.zzisi = bl;
        this.zzirp = l3;
        this.zzirl = n2;
        this.zzisj = f;
        this.zzisk = l4;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationRequest locationRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, (int)locationRequest.mPriority);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)locationRequest.zzisg);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)locationRequest.zzish);
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean)locationRequest.zzisi);
        zzbgo.zza((Parcel)parcel2, (int)5, (long)locationRequest.zzirp);
        zzbgo.zzc((Parcel)parcel2, (int)6, (int)locationRequest.zzirl);
        zzbgo.zza((Parcel)parcel2, (int)7, (float)locationRequest.zzisj);
        zzbgo.zza((Parcel)parcel2, (int)8, (long)locationRequest.zzisk);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Request[");
        switch (this.mPriority) {
            case 100: {
                string = "PRIORITY_HIGH_ACCURACY";
                break;
            }
            case 102: {
                string = "PRIORITY_BALANCED_POWER_ACCURACY";
                break;
            }
            case 104: {
                string = "PRIORITY_LOW_POWER";
                break;
            }
            case 105: {
                string = "PRIORITY_NO_POWER";
                break;
            }
            default: {
                string = "???";
            }
        }
        stringBuilder2.append(string);
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzisg).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzish).append("ms");
        if (this.zzisk > this.zzisg) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzisk).append("ms");
        }
        if (this.zzisj > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzisj).append("m");
        }
        if (this.zzirp != Long.MAX_VALUE) {
            long l = this.zzirp - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzirl != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzirl);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.mPriority, this.zzisg, Float.valueOf(this.zzisj), this.zzisk});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.zzisg == locationRequest.zzisg && this.zzish == locationRequest.zzish && this.zzisi == locationRequest.zzisi && this.zzirp == locationRequest.zzirp && this.zzirl == locationRequest.zzirl && this.zzisj == locationRequest.zzisj && this.getMaxWaitTime() == locationRequest.getMaxWaitTime();
    }
}

