/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.Context;
import android.location.Location;
import android.os.RemoteException;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.location.zzaj;
import com.google.android.gms.internal.location.zzao;
import com.google.android.gms.internal.location.zzat;
import com.google.android.gms.internal.location.zzaw;
import com.google.android.gms.internal.location.zzax;
import com.google.android.gms.internal.location.zzb;
import com.google.android.gms.internal.location.zzbd;
import com.google.android.gms.internal.location.zzbf;
import com.google.android.gms.internal.location.zzbj;
import com.google.android.gms.internal.location.zzo;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import java.util.HashMap;
import java.util.Map;

public final class zzas {
    private final zzbj<zzao> zzcb;
    private final Context zzcu;
    private ContentProviderClient zzcv = null;
    private boolean zzcw = false;
    private final Map<ListenerHolder.ListenerKey<LocationListener>, zzax> zzcx = new HashMap<ListenerHolder.ListenerKey<LocationListener>, zzax>();
    private final Map<ListenerHolder.ListenerKey<Object>, zzaw> zzcy = new HashMap<ListenerHolder.ListenerKey<Object>, zzaw>();
    private final Map<ListenerHolder.ListenerKey<LocationCallback>, zzat> zzcz = new HashMap<ListenerHolder.ListenerKey<LocationCallback>, zzat>();

    public zzas(Context context, zzbj<zzao> zzbj2) {
        this.zzcu = context;
        this.zzcb = zzbj2;
    }

    public final Location getLastLocation() throws RemoteException {
        this.zzcb.checkConnected();
        return this.zzcb.getService().zza(this.zzcu.getPackageName());
    }

    public final LocationAvailability zza() throws RemoteException {
        this.zzcb.checkConnected();
        return this.zzcb.getService().zzb(this.zzcu.getPackageName());
    }

    public final void zza(LocationRequest locationRequest, ListenerHolder<LocationListener> listenerHolder, zzaj zzaj2) throws RemoteException {
        this.zzcb.checkConnected();
        zzax zzax2 = this.zza(listenerHolder);
        zzaj zzaj3 = zzaj2;
        zzax zzax3 = zzax2;
        zzbd zzbd2 = zzbd.zza(locationRequest);
        this.zzcb.getService().zza(new zzbf(1, zzbd2, zzax3.asBinder(), null, null, zzaj3 != null ? zzaj3.asBinder() : null));
    }

    public final void zza(zzbd zzbd2, ListenerHolder<LocationCallback> listenerHolder, zzaj zzaj2) throws RemoteException {
        this.zzcb.checkConnected();
        zzat zzat2 = this.zzb(listenerHolder);
        zzaj zzaj3 = zzaj2;
        zzat zzat3 = zzat2;
        zzbd zzbd3 = zzbd2;
        this.zzcb.getService().zza(new zzbf(1, zzbd3, null, null, zzat3.asBinder(), zzaj3 != null ? zzaj3.asBinder() : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final zzax zza(ListenerHolder<LocationListener> listenerHolder) {
        Map<ListenerHolder.ListenerKey<LocationListener>, zzax> map = this.zzcx;
        synchronized (map) {
            zzax zzax2 = this.zzcx.get(listenerHolder.getListenerKey());
            if (zzax2 == null) {
                zzax2 = new zzax(listenerHolder);
            }
            this.zzcx.put((ListenerHolder.ListenerKey<LocationListener>)listenerHolder.getListenerKey(), zzax2);
            return zzax2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final zzat zzb(ListenerHolder<LocationCallback> listenerHolder) {
        Map<ListenerHolder.ListenerKey<LocationCallback>, zzat> map = this.zzcz;
        synchronized (map) {
            zzat zzat2 = this.zzcz.get(listenerHolder.getListenerKey());
            if (zzat2 == null) {
                zzat2 = new zzat(listenerHolder);
            }
            this.zzcz.put((ListenerHolder.ListenerKey<LocationCallback>)listenerHolder.getListenerKey(), zzat2);
            return zzat2;
        }
    }

    public final void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzaj zzaj2) throws RemoteException {
        this.zzcb.checkConnected();
        zzaj zzaj3 = zzaj2;
        PendingIntent pendingIntent2 = pendingIntent;
        zzbd zzbd2 = zzbd.zza(locationRequest);
        this.zzcb.getService().zza(new zzbf(1, zzbd2, null, pendingIntent2, null, zzaj3 != null ? zzaj3.asBinder() : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(ListenerHolder.ListenerKey<LocationListener> listenerKey, zzaj zzaj2) throws RemoteException {
        this.zzcb.checkConnected();
        Preconditions.checkNotNull(listenerKey, (Object)"Invalid null listener key");
        Map<ListenerHolder.ListenerKey<LocationListener>, zzax> map = this.zzcx;
        synchronized (map) {
            zzax zzax2 = this.zzcx.remove(listenerKey);
            if (zzax2 != null) {
                zzax2.release();
                this.zzcb.getService().zza(zzbf.zza(zzax2, zzaj2));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(ListenerHolder.ListenerKey<LocationCallback> listenerKey, zzaj zzaj2) throws RemoteException {
        this.zzcb.checkConnected();
        Preconditions.checkNotNull(listenerKey, (Object)"Invalid null listener key");
        Map<ListenerHolder.ListenerKey<LocationCallback>, zzat> map = this.zzcz;
        synchronized (map) {
            zzat zzat2 = this.zzcz.remove(listenerKey);
            if (zzat2 != null) {
                zzat2.release();
                this.zzcb.getService().zza(zzbf.zza(zzat2, zzaj2));
            }
            return;
        }
    }

    public final void zza(PendingIntent pendingIntent, zzaj zzaj2) throws RemoteException {
        this.zzcb.checkConnected();
        zzaj zzaj3 = zzaj2;
        PendingIntent pendingIntent2 = pendingIntent;
        this.zzcb.getService().zza(new zzbf(2, null, null, pendingIntent2, null, zzaj3 != null ? zzaj3.asBinder() : null));
    }

    public final void zza(boolean bl) throws RemoteException {
        this.zzcb.checkConnected();
        this.zzcb.getService().zza(bl);
        this.zzcw = bl;
    }

    public final void zza(Location location) throws RemoteException {
        this.zzcb.checkConnected();
        this.zzcb.getService().zza(location);
    }

    public final void zza(zzaj zzaj2) throws RemoteException {
        this.zzcb.checkConnected();
        this.zzcb.getService().zza(zzaj2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllListeners() throws RemoteException {
        zzas zzas2 = this;
        Map<Object, zzb> map = zzas2.zzcx;
        synchronized (map) {
            for (zzax zzb2 : zzas2.zzcx.values()) {
                if (zzb2 == null) continue;
                zzas2.zzcb.getService().zza(zzbf.zza(zzb2, null));
            }
            zzas2.zzcx.clear();
        }
        map = zzas2.zzcz;
        synchronized (map) {
            for (zzat zzat2 : zzas2.zzcz.values()) {
                if (zzat2 == null) continue;
                zzas2.zzcb.getService().zza(zzbf.zza(zzat2, null));
            }
            zzas2.zzcz.clear();
        }
        zzas2 = this;
        map = zzas2.zzcy;
        synchronized (map) {
            for (zzaw zzaw2 : zzas2.zzcy.values()) {
                if (zzaw2 == null) continue;
                zzaw zzaw3 = zzaw2;
                zzas2.zzcb.getService().zza(new zzo(2, null, zzaw3.asBinder(), null));
            }
            zzas2.zzcy.clear();
            return;
        }
    }

    public final void zzb() throws RemoteException {
        if (this.zzcw) {
            this.zza(false);
        }
    }
}

