/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.DetectedActivity;
import com.google.android.gms.location.zzc;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionCreator")
public class ActivityTransition
extends AbstractSafeParcelable {
    public static final int ACTIVITY_TRANSITION_ENTER = 0;
    public static final int ACTIVITY_TRANSITION_EXIT = 1;
    public static final Parcelable.Creator<ActivityTransition> CREATOR = new zzc();
    @SafeParcelable.Field(id=1, getter="getActivityType")
    private final int zzi;
    @SafeParcelable.Field(id=2, getter="getTransitionType")
    private final int zzj;

    @SafeParcelable.Constructor
    ActivityTransition(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2) {
        this.zzi = n;
        this.zzj = n2;
    }

    public int getActivityType() {
        return this.zzi;
    }

    public int getTransitionType() {
        return this.zzj;
    }

    public static void zza(int n) {
        Preconditions.checkArgument((n >= 0 && n <= 1 ? 1 : 0) != 0, (Object)new StringBuilder(41).append("Transition type ").append(n).append(" is not valid.").toString());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzi, this.zzj});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ActivityTransition)) {
            return false;
        }
        ActivityTransition activityTransition = (ActivityTransition)((Object)object);
        return this.zzi == activityTransition.zzi && this.zzj == activityTransition.zzj;
    }

    public String toString() {
        int n = this.zzi;
        int n2 = this.zzj;
        return new StringBuilder(75).append("ActivityTransition [mActivityType=").append(n).append(", mTransitionType=").append(n2).append(']').toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityTransition activityTransition = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)activityTransition.getActivityType());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)activityTransition.getTransitionType());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private int zzi = -1;
        private int zzj = -1;

        public Builder() {
        }

        public Builder setActivityType(int n) {
            DetectedActivity.zzb(n);
            this.zzi = n;
            return this;
        }

        public Builder setActivityTransition(int n) {
            ActivityTransition.zza(n);
            this.zzj = n;
            return this;
        }

        public ActivityTransition build() {
            Preconditions.checkState((this.zzi != -1 ? 1 : 0) != 0, (Object)"Activity type not set.");
            Preconditions.checkState((this.zzj != -1 ? 1 : 0) != 0, (Object)"Activity transition type not set.");
            return new ActivityTransition(this.zzi, this.zzj);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SupportedActivityTransition {
    }
}

