/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.location.zzab;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationRequestCreator")
public final class LocationRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    @SafeParcelable.Field(id=1, defaultValueUnchecked="LocationRequest.DEFAULT_PRIORITY")
    private int priority;
    @SafeParcelable.Field(id=2, defaultValueUnchecked="LocationRequest.DEFAULT_INTERVAL")
    private long zzaw;
    @SafeParcelable.Field(id=3, defaultValueUnchecked="LocationRequest.DEFAULT_FASTEST_INTERVAL")
    private long zzax;
    @SafeParcelable.Field(id=4, defaultValueUnchecked="LocationRequest.DEFAULT_EXPLICIT_FASTEST_INTERVAL")
    private boolean zzay;
    @SafeParcelable.Field(id=5, defaultValueUnchecked="LocationRequest.DEFAULT_EXPIRE_AT")
    private long zzaf;
    @SafeParcelable.Field(id=6, defaultValueUnchecked="LocationRequest.DEFAULT_NUM_UPDATES")
    private int zzx;
    @SafeParcelable.Field(id=7, defaultValueUnchecked="LocationRequest.DEFAULT_SMALLEST_DISPLACEMENT")
    private float zzaz;
    @SafeParcelable.Field(id=8, defaultValueUnchecked="LocationRequest.DEFAULT_MAX_WAIT_TIME")
    private long zzba;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzab();

    @VisibleForTesting
    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.priority = 102;
        this.zzaw = 3600000L;
        this.zzax = 600000L;
        this.zzay = false;
        this.zzaf = Long.MAX_VALUE;
        this.zzx = Integer.MAX_VALUE;
        this.zzaz = 0.0f;
        this.zzba = 0L;
    }

    @VisibleForTesting
    public final LocationRequest setPriority(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
        this.priority = n;
        return this;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final LocationRequest setInterval(long l) {
        LocationRequest.zza(l);
        this.zzaw = l;
        if (!this.zzay) {
            this.zzax = (long)((double)this.zzaw / 6.0);
        }
        return this;
    }

    public final long getInterval() {
        return this.zzaw;
    }

    @VisibleForTesting
    public final LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zza(l);
        this.zzba = l;
        return this;
    }

    public final long getMaxWaitTime() {
        long l = this.zzba;
        if (l < this.zzaw) {
            l = this.zzaw;
        }
        return l;
    }

    public final LocationRequest setFastestInterval(long l) {
        LocationRequest.zza(l);
        this.zzay = true;
        this.zzax = l;
        return this;
    }

    public final long getFastestInterval() {
        return this.zzax;
    }

    public final boolean isFastestIntervalExplicitlySet() {
        return this.zzay;
    }

    public final LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zzaf = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zzaf < 0L) {
            this.zzaf = 0L;
        }
        return this;
    }

    @VisibleForTesting
    public final LocationRequest setExpirationTime(long l) {
        this.zzaf = l;
        if (this.zzaf < 0L) {
            this.zzaf = 0L;
        }
        return this;
    }

    public final long getExpirationTime() {
        return this.zzaf;
    }

    @VisibleForTesting
    public final LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzx = n;
        return this;
    }

    public final int getNumUpdates() {
        return this.zzx;
    }

    @VisibleForTesting
    public final LocationRequest setSmallestDisplacement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
        this.zzaz = f;
        return this;
    }

    public final float getSmallestDisplacement() {
        return this.zzaz;
    }

    private static void zza(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    @SafeParcelable.Constructor
    LocationRequest(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) long l2, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) long l3, @SafeParcelable.Param(id=6) int n2, @SafeParcelable.Param(id=7) float f, @SafeParcelable.Param(id=8) long l4) {
        this.priority = n;
        this.zzaw = l;
        this.zzax = l2;
        this.zzay = bl;
        this.zzaf = l3;
        this.zzx = n2;
        this.zzaz = f;
        this.zzba = l4;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationRequest locationRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)locationRequest.priority);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)2, (long)locationRequest.zzaw);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)3, (long)locationRequest.zzax);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)locationRequest.zzay);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)5, (long)locationRequest.zzaf);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)6, (int)locationRequest.zzx);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)7, (float)locationRequest.zzaz);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)8, (long)locationRequest.zzba);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Request[");
        switch (this.priority) {
            case 100: {
                string = "PRIORITY_HIGH_ACCURACY";
                break;
            }
            case 102: {
                string = "PRIORITY_BALANCED_POWER_ACCURACY";
                break;
            }
            case 104: {
                string = "PRIORITY_LOW_POWER";
                break;
            }
            case 105: {
                string = "PRIORITY_NO_POWER";
                break;
            }
            default: {
                string = "???";
            }
        }
        stringBuilder2.append(string);
        if (this.priority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzaw).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzax).append("ms");
        if (this.zzba > this.zzaw) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzba).append("ms");
        }
        if (this.zzaz > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzaz).append("m");
        }
        if (this.zzaf != Long.MAX_VALUE) {
            long l = this.zzaf - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzx != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzx);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.priority, this.zzaw, Float.valueOf(this.zzaz), this.zzba});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.priority == locationRequest.priority && this.zzaw == locationRequest.zzaw && this.zzax == locationRequest.zzax && this.zzay == locationRequest.zzay && this.zzaf == locationRequest.zzaf && this.zzx == locationRequest.zzx && this.zzaz == locationRequest.zzaz && this.getMaxWaitTime() == locationRequest.getMaxWaitTime();
    }
}

