/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.IStatusCallback;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.StatusCallback;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.location.zzaj;
import com.google.android.gms.internal.location.zzao;
import com.google.android.gms.internal.location.zzas;
import com.google.android.gms.internal.location.zzba;
import com.google.android.gms.internal.location.zzbb;
import com.google.android.gms.internal.location.zzbc;
import com.google.android.gms.internal.location.zzbd;
import com.google.android.gms.internal.location.zzk;
import com.google.android.gms.location.ActivityTransitionRequest;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.zzal;
import javax.annotation.Nullable;

public final class zzaz
extends zzk {
    private final zzas zzde;

    public zzaz(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, ClientSettings.createDefault((Context)context));
    }

    public zzaz(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, @Nullable ClientSettings clientSettings) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, clientSettings);
        this.zzde = new zzas(context, this.zzcb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        zzas zzas2 = this.zzde;
        synchronized (zzas2) {
            if (this.isConnected()) {
                try {
                    this.zzde.removeAllListeners();
                    this.zzde.zzb();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
            return;
        }
    }

    public final void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)pendingIntent);
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzao)this.getService()).zza(l, true, pendingIntent);
    }

    public final void zza(ActivityTransitionRequest activityTransitionRequest, PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        StatusCallback statusCallback = new StatusCallback(resultHolder);
        ((zzao)this.getService()).zza(activityTransitionRequest, pendingIntent, (IStatusCallback)statusCallback);
    }

    public final void zza(PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        StatusCallback statusCallback = new StatusCallback(resultHolder);
        ((zzao)this.getService()).zza(pendingIntent, (IStatusCallback)statusCallback);
    }

    public final void zzb(PendingIntent pendingIntent) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)pendingIntent);
        ((zzao)this.getService()).zzb(pendingIntent);
    }

    public final void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)((Object)geofencingRequest), (Object)"geofencingRequest can't be null.");
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        zzba zzba2 = new zzba(resultHolder);
        ((zzao)this.getService()).zza(geofencingRequest, pendingIntent, zzba2);
    }

    public final void zza(zzal zzal2, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)((Object)zzal2), (Object)"removeGeofencingRequest can't be null.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        zzbb zzbb2 = new zzbb(resultHolder);
        ((zzao)this.getService()).zza(zzal2, zzbb2);
    }

    public final Location getLastLocation() throws RemoteException {
        return this.zzde.getLastLocation();
    }

    public final LocationAvailability zza() throws RemoteException {
        return this.zzde.zza();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzbd zzbd2, ListenerHolder<LocationCallback> listenerHolder, zzaj zzaj2) throws RemoteException {
        zzas zzas2 = this.zzde;
        synchronized (zzas2) {
            this.zzde.zza(zzbd2, listenerHolder, zzaj2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(LocationRequest locationRequest, ListenerHolder<LocationListener> listenerHolder, zzaj zzaj2) throws RemoteException {
        zzas zzas2 = this.zzde;
        synchronized (zzas2) {
            this.zzde.zza(locationRequest, listenerHolder, zzaj2);
            return;
        }
    }

    public final void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzaj zzaj2) throws RemoteException {
        this.zzde.zza(locationRequest, pendingIntent, zzaj2);
    }

    public final void zza(ListenerHolder.ListenerKey<LocationListener> listenerKey, zzaj zzaj2) throws RemoteException {
        this.zzde.zza(listenerKey, zzaj2);
    }

    public final void zza(PendingIntent pendingIntent, zzaj zzaj2) throws RemoteException {
        this.zzde.zza(pendingIntent, zzaj2);
    }

    public final void zzb(ListenerHolder.ListenerKey<LocationCallback> listenerKey, zzaj zzaj2) throws RemoteException {
        this.zzde.zzb(listenerKey, zzaj2);
    }

    public final void zza(boolean bl) throws RemoteException {
        this.zzde.zza(bl);
    }

    public final void zza(Location location) throws RemoteException {
        this.zzde.zza(location);
    }

    public final void zza(zzaj zzaj2) throws RemoteException {
        this.zzde.zza(zzaj2);
    }

    public final void zza(LocationSettingsRequest locationSettingsRequest, BaseImplementation.ResultHolder<LocationSettingsResult> resultHolder, @Nullable String string) throws RemoteException {
        this.checkConnected();
        Preconditions.checkArgument((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        Preconditions.checkArgument((resultHolder != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzbc zzbc2 = new zzbc(resultHolder);
        ((zzao)this.getService()).zza(locationSettingsRequest, zzbc2, string);
    }
}

