/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.ClientIdentity;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzbb;
import com.google.android.gms.location.LocationRequest;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000, 2, 3, 4})
@SafeParcelable.Class(creator="LocationRequestInternalCreator")
public final class zzbc
extends AbstractSafeParcelable {
    static final List<ClientIdentity> zza = Collections.emptyList();
    @SafeParcelable.Field(id=1, defaultValueUnchecked="null")
    private LocationRequest zzb;
    @SafeParcelable.Field(id=5, defaultValueUnchecked="LocationRequestInternal.DEFAULT_CLIENTS")
    private List<ClientIdentity> zzc;
    @SafeParcelable.Field(id=6, defaultValueUnchecked="null")
    @Nullable
    private String zzd;
    @SafeParcelable.Field(id=7, defaultValueUnchecked="LocationRequestInternal.DEFAULT_HIDE_FROM_APP_OPS")
    private boolean zze;
    @SafeParcelable.Field(id=8, defaultValueUnchecked="LocationRequestInternal.DEFAULT_FORCE_COARSE_LOCATION")
    private boolean zzf;
    @SafeParcelable.Field(id=9, defaultValueUnchecked="LocationRequestInternal.DEFAULT_EXEMPT_FROM_THROTTLE")
    private boolean zzg;
    @SafeParcelable.Field(id=10, defaultValueUnchecked="null")
    @Nullable
    private String zzh;
    @SafeParcelable.Field(id=11, defaultValueUnchecked="false")
    private boolean zzi;
    @SafeParcelable.Field(id=12, defaultValueUnchecked="false")
    private boolean zzj;
    @SafeParcelable.Field(id=13, defaultValueUnchecked="null")
    @Nullable
    private String zzk;
    @SafeParcelable.Field(id=14, defaultValueUnchecked="LocationRequestInternal.DEFAULT_MAX_LOCATION_AGE_MILLIS")
    private long zzl;
    private boolean zzm = true;
    public static final Parcelable.Creator<zzbc> CREATOR = new zzbb();

    @Deprecated
    public static zzbc zza(LocationRequest locationRequest) {
        return zzbc.zza(null, locationRequest);
    }

    public static zzbc zza(@Nullable String string, LocationRequest locationRequest) {
        return new zzbc(locationRequest, zza, null, false, false, false, null, false, false, null, Long.MAX_VALUE);
    }

    @SafeParcelable.Constructor
    zzbc(@SafeParcelable.Param(id=1) LocationRequest locationRequest, @SafeParcelable.Param(id=5) List<ClientIdentity> list, @SafeParcelable.Param(id=6) @Nullable String string, @SafeParcelable.Param(id=7) boolean bl, @SafeParcelable.Param(id=8) boolean bl2, @SafeParcelable.Param(id=9) boolean bl3, @SafeParcelable.Param(id=10) @Nullable String string2, @SafeParcelable.Param(id=11) boolean bl4, @SafeParcelable.Param(id=12) boolean bl5, @SafeParcelable.Param(id=13) String string3, @SafeParcelable.Param(id=14) long l) {
        this.zzb = locationRequest;
        this.zzc = list;
        this.zzd = string;
        this.zze = bl;
        this.zzf = bl2;
        this.zzg = bl3;
        this.zzh = string2;
        this.zzi = bl4;
        this.zzj = bl5;
        this.zzk = string3;
        this.zzl = l;
    }

    public final zzbc zza(long l) {
        if (this.zzb.getMaxWaitTime() > this.zzb.getInterval()) {
            long l2 = this.zzb.getInterval();
            long l3 = this.zzb.getMaxWaitTime();
            throw new IllegalArgumentException(new StringBuilder(120).append("could not set max age when location batching is requested, interval=").append(l2).append("maxWaitTime=").append(l3).toString());
        }
        this.zzl = 10000L;
        return this;
    }

    public final zzbc zza(String string) {
        this.zzk = string;
        return this;
    }

    public final zzbc zza(boolean bl) {
        this.zzj = true;
        return this;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzbc zzbc2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)zzbc2.zzb, (int)n, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)5, zzbc2.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)zzbc2.zzd, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)7, (boolean)zzbc2.zze);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)8, (boolean)zzbc2.zzf);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)zzbc2.zzg);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)zzbc2.zzh, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)11, (boolean)zzbc2.zzi);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)12, (boolean)zzbc2.zzj);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)13, (String)zzbc2.zzk, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)14, (long)zzbc2.zzl);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.zzb);
        if (this.zzd != null) {
            stringBuilder.append(" tag=").append(this.zzd);
        }
        if (this.zzh != null) {
            stringBuilder.append(" moduleId=").append(this.zzh);
        }
        if (this.zzk != null) {
            stringBuilder.append(" contextAttributionTag=").append(this.zzk);
        }
        stringBuilder.append(" hideAppOps=").append(this.zze);
        stringBuilder.append(" clients=").append(this.zzc);
        stringBuilder.append(" forceCoarseLocation=").append(this.zzf);
        if (this.zzg) {
            stringBuilder.append(" exemptFromBackgroundThrottle");
        }
        if (this.zzi) {
            stringBuilder.append(" locationSettingsIgnored");
        }
        if (this.zzj) {
            stringBuilder.append(" inaccurateLocationsDelayed");
        }
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof zzbc)) {
            return false;
        }
        zzbc zzbc2 = (zzbc)((Object)object);
        return Objects.equal((Object)((Object)this.zzb), (Object)((Object)zzbc2.zzb)) && Objects.equal(this.zzc, zzbc2.zzc) && Objects.equal((Object)this.zzd, (Object)zzbc2.zzd) && this.zze == zzbc2.zze && this.zzf == zzbc2.zzf && this.zzg == zzbc2.zzg && Objects.equal((Object)this.zzh, (Object)zzbc2.zzh) && this.zzi == zzbc2.zzi && this.zzj == zzbc2.zzj && Objects.equal((Object)this.zzk, (Object)zzbc2.zzk);
    }

    public final int hashCode() {
        return this.zzb.hashCode();
    }
}

