/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzbg;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzal;
import java.util.ArrayList;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="GeofencingRequestCreator")
public class GeofencingRequest
extends AbstractSafeParcelable {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzal();
    @SafeParcelable.Field(id=1, getter="getParcelableGeofences")
    private final List<zzbg> zza;
    @SafeParcelable.Field(id=2, getter="getInitialTrigger")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getTag", defaultValue="")
    private final String zzc;

    @SafeParcelable.Constructor
    GeofencingRequest(@SafeParcelable.Param(id=1) List<zzbg> list, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string) {
        this.zza = list;
        this.zzb = n;
        this.zzc = string;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zza);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzb;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GeofencingRequest geofencingRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)1, geofencingRequest.zza, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)geofencingRequest.getInitialTrigger());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)geofencingRequest.zzc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GeofencingRequest[");
        stringBuilder.append("geofences=");
        stringBuilder.append(this.zza);
        int n = this.zzb;
        stringBuilder.append(new StringBuilder(30).append(", initialTrigger=").append(n).append(", ").toString());
        String string = String.valueOf(this.zzc);
        stringBuilder.append(string.length() != 0 ? "tag=".concat(string) : new String("tag="));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final class Builder {
        private final List<zzbg> zza = new ArrayList<zzbg>();
        private int zzb = 5;
        private String zzc = "";

        public final Builder addGeofence(Geofence geofence) {
            Preconditions.checkNotNull((Object)geofence, (Object)"geofence can't be null.");
            Preconditions.checkArgument((boolean)(geofence instanceof zzbg), (Object)"Geofence must be created using Geofence.Builder.");
            this.zza.add((zzbg)geofence);
            return this;
        }

        public final Builder addGeofences(List<Geofence> list) {
            if (list == null || list.isEmpty()) {
                return this;
            }
            for (Geofence geofence : list) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public final Builder setInitialTrigger(int n) {
            this.zzb = n & 7;
            return this;
        }

        public final GeofencingRequest build() {
            Preconditions.checkArgument((!this.zza.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zza, this.zzb, this.zzc);
        }
    }
}

