/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.ClientIdentity;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.ActivityTransition;
import com.google.android.gms.location.zzi;
import com.google.android.gms.location.zzj;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionRequestCreator")
public class ActivityTransitionRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<ActivityTransitionRequest> CREATOR = new zzj();
    public static final Comparator<ActivityTransition> IS_SAME_TRANSITION = new zzi();
    @SafeParcelable.Field(id=1, getter="getActivityTransitions")
    private final List<ActivityTransition> zza;
    @SafeParcelable.Field(id=2, getter="getTag")
    @Nullable
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getClients")
    private final List<ClientIdentity> zzc;

    @SafeParcelable.Constructor
    public ActivityTransitionRequest(@SafeParcelable.Param(id=1) List<ActivityTransition> list, @SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) @Nullable List<ClientIdentity> list2) {
        Preconditions.checkNotNull(list, (Object)"transitions can't be null");
        Preconditions.checkArgument((list.size() > 0 ? 1 : 0) != 0, (Object)"transitions can't be empty.");
        List<ActivityTransition> list3 = list;
        TreeSet<ActivityTransition> treeSet = new TreeSet<ActivityTransition>(IS_SAME_TRANSITION);
        for (ActivityTransition activityTransition : list3) {
            Preconditions.checkArgument((boolean)treeSet.add(activityTransition), (Object)String.format("Found duplicated transition: %s.", new Object[]{activityTransition}));
        }
        this.zza = Collections.unmodifiableList(list);
        this.zzb = string;
        this.zzc = list2 == null ? Collections.emptyList() : Collections.unmodifiableList(list2);
    }

    public ActivityTransitionRequest(List<ActivityTransition> list) {
        this(list, null, null);
    }

    public void serializeToIntentExtra(Intent intent) {
        SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)this, (Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_REQUEST");
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityTransitionRequest activityTransitionRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)1, activityTransitionRequest.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)activityTransitionRequest.zzb, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)3, activityTransitionRequest.zzc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ActivityTransitionRequest activityTransitionRequest = (ActivityTransitionRequest)((Object)object);
        return Objects.equal(this.zza, activityTransitionRequest.zza) && Objects.equal((Object)this.zzb, (Object)activityTransitionRequest.zzb) && Objects.equal(this.zzc, activityTransitionRequest.zzc);
    }

    public String toString() {
        String string = String.valueOf(this.zza);
        String string2 = this.zzb;
        String string3 = String.valueOf(this.zzc);
        return new StringBuilder(61 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ActivityTransitionRequest [mTransitions=").append(string).append(", mTag='").append(string2).append('\'').append(", mClients=").append(string3).append(']').toString();
    }

    public int hashCode() {
        return (this.zza.hashCode() * 31 + (this.zzb != null ? this.zzb.hashCode() : 0)) * 31 + (this.zzc != null ? this.zzc.hashCode() : 0);
    }
}

