/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.location.zzae;
import com.google.android.gms.internal.location.zzay;
import com.google.android.gms.internal.location.zzbh;
import com.google.android.gms.internal.location.zzn;
import com.google.android.gms.location.FusedLocationProviderApi;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.GeofencingApi;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.SettingsApi;
import com.google.android.gms.location.SettingsClient;
import com.google.android.gms.location.zzax;

public class LocationServices {
    private static final Api.ClientKey<zzay> zza = new Api.ClientKey();
    private static final Api.AbstractClientBuilder<zzay, Api.ApiOptions.NoOptions> zzb = new zzax();
    public static final Api<Api.ApiOptions.NoOptions> API = new Api("LocationServices.API", zzb, zza);
    @Deprecated
    public static final FusedLocationProviderApi FusedLocationApi = new zzn();
    @Deprecated
    public static final GeofencingApi GeofencingApi = new zzae();
    @Deprecated
    public static final SettingsApi SettingsApi = new zzbh();

    private LocationServices() {
    }

    public static zzay zza(GoogleApiClient googleApiClient) {
        Preconditions.checkArgument((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzay zzay2 = (zzay)googleApiClient.getClient(zza);
        Preconditions.checkState((zzay2 != null ? 1 : 0) != 0, (Object)"GoogleApiClient is not configured to use the LocationServices.API Api. Pass thisinto GoogleApiClient.Builder#addApi() to use this feature.");
        return zzay2;
    }

    public static GeofencingClient getGeofencingClient(@NonNull Activity activity) {
        return new GeofencingClient(activity);
    }

    public static GeofencingClient getGeofencingClient(@NonNull Context context) {
        return new GeofencingClient(context);
    }

    public static SettingsClient getSettingsClient(@NonNull Activity activity) {
        return new SettingsClient(activity);
    }

    public static SettingsClient getSettingsClient(@NonNull Context context) {
        return new SettingsClient(context);
    }

    public static FusedLocationProviderClient getFusedLocationProviderClient(@NonNull Activity activity) {
        return new FusedLocationProviderClient(activity);
    }

    public static FusedLocationProviderClient getFusedLocationProviderClient(@NonNull Context context) {
        return new FusedLocationProviderClient(context);
    }

    public static abstract class zza<R extends Result>
    extends BaseImplementation.ApiMethodImpl<R, zzay> {
        public zza(GoogleApiClient googleApiClient) {
            super(API, googleApiClient);
        }
    }
}

