/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.IStatusCallback;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.StatusCallback;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.internal.location.zzai;
import com.google.android.gms.internal.location.zzam;
import com.google.android.gms.internal.location.zzav;
import com.google.android.gms.internal.location.zzaw;
import com.google.android.gms.internal.location.zzax;
import com.google.android.gms.internal.location.zzay;
import com.google.android.gms.internal.location.zzba;
import com.google.android.gms.internal.location.zzi;
import com.google.android.gms.location.ActivityTransitionRequest;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.zzbq;
import com.google.android.gms.location.zzu;
import java.util.List;

public final class zzaz
extends zzi {
    private final zzav zzf;

    public zzaz(Context context, Looper object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, ClientSettings clientSettings) {
        super(context, (Looper)object, connectionCallbacks, onConnectionFailedListener, string, clientSettings);
        super(context, this.zze);
        this.zzf = object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void disconnect() {
        zzav zzav2 = this.zzf;
        synchronized (zzav2) {
            boolean bl = this.isConnected();
            if (bl) {
                try {
                    this.zzf.zzn();
                    this.zzf.zzo();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzq(long l, PendingIntent pendingIntent) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)pendingIntent);
        boolean bl = l >= 0L;
        Preconditions.checkArgument((boolean)bl, (Object)"detectionIntervalMillis must be >= 0");
        ((zzam)this.getService()).zzh(l, true, pendingIntent);
    }

    public final void zzr(ActivityTransitionRequest activityTransitionRequest, PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)((Object)activityTransitionRequest), (Object)"activityTransitionRequest must be specified.");
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        StatusCallback statusCallback = new StatusCallback(resultHolder);
        ((zzam)this.getService()).zzi(activityTransitionRequest, pendingIntent, (IStatusCallback)statusCallback);
    }

    public final void zzs(PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        StatusCallback statusCallback = new StatusCallback(resultHolder);
        ((zzam)this.getService()).zzj(pendingIntent, (IStatusCallback)statusCallback);
    }

    public final void zzt(PendingIntent pendingIntent) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)pendingIntent);
        ((zzam)this.getService()).zzk(pendingIntent);
    }

    public final void zzu(PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        StatusCallback statusCallback = new StatusCallback(resultHolder);
        ((zzam)this.getService()).zzl(pendingIntent, (IStatusCallback)statusCallback);
    }

    public final void zzv(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)((Object)geofencingRequest), (Object)"geofencingRequest can't be null.");
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        zzaw zzaw2 = new zzaw(resultHolder);
        ((zzam)this.getService()).zzd(geofencingRequest, pendingIntent, zzaw2);
    }

    public final void zzw(zzbq zzbq2, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)((Object)zzbq2), (Object)"removeGeofencingRequest can't be null.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        zzax zzax2 = new zzax(resultHolder);
        ((zzam)this.getService()).zzg(zzbq2, zzax2);
    }

    public final void zzx(PendingIntent pendingIntent, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        this.checkConnected();
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        zzax zzax2 = new zzax(resultHolder);
        ((zzam)this.getService()).zze(pendingIntent, zzax2, this.getContext().getPackageName());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzy(List<String> stringArray, BaseImplementation.ResultHolder<Status> resultHolder) throws RemoteException {
        void var3_4;
        this.checkConnected();
        if (stringArray != null) {
            if (stringArray.size() > 0) {
                boolean bl = true;
            } else {
                boolean bl = false;
            }
        } else {
            boolean bl = false;
        }
        Preconditions.checkArgument((boolean)var3_4, (Object)"geofenceRequestIds can't be null nor empty.");
        Preconditions.checkNotNull(resultHolder, (Object)"ResultHolder not provided.");
        String[] stringArray2 = new String[]{};
        stringArray = stringArray.toArray(stringArray2);
        zzax zzax2 = new zzax(resultHolder);
        ((zzam)this.getService()).zzf(stringArray, zzax2, this.getContext().getPackageName());
    }

    public final Location zzz(String string) throws RemoteException {
        if (ArrayUtils.contains((Object[])this.getAvailableFeatures(), (Object)zzu.zzc)) {
            return this.zzf.zza(string);
        }
        return this.zzf.zzb();
    }

    public final LocationAvailability zzA() throws RemoteException {
        return this.zzf.zzc();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzB(zzba zzba2, ListenerHolder<LocationCallback> listenerHolder, zzai zzai2) throws RemoteException {
        zzav zzav2 = this.zzf;
        synchronized (zzav2) {
            this.zzf.zze(zzba2, listenerHolder, zzai2);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzC(LocationRequest locationRequest, ListenerHolder<LocationListener> listenerHolder, zzai zzai2) throws RemoteException {
        zzav zzav2 = this.zzf;
        synchronized (zzav2) {
            this.zzf.zzd(locationRequest, listenerHolder, zzai2);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzD(zzba zzba2, PendingIntent pendingIntent, zzai zzai2) throws RemoteException {
        this.zzf.zzf(zzba2, pendingIntent, zzai2);
    }

    public final void zzE(LocationRequest locationRequest, PendingIntent pendingIntent, zzai zzai2) throws RemoteException {
        this.zzf.zzg(locationRequest, pendingIntent, zzai2);
    }

    public final void zzF(ListenerHolder.ListenerKey<LocationListener> listenerKey, zzai zzai2) throws RemoteException {
        this.zzf.zzh(listenerKey, zzai2);
    }

    public final void zzG(PendingIntent pendingIntent, zzai zzai2) throws RemoteException {
        this.zzf.zzj(pendingIntent, zzai2);
    }

    public final void zzH(ListenerHolder.ListenerKey<LocationCallback> listenerKey, zzai zzai2) throws RemoteException {
        this.zzf.zzi(listenerKey, zzai2);
    }

    public final void zzI(boolean bl) throws RemoteException {
        this.zzf.zzk(bl);
    }

    public final void zzJ(Location location) throws RemoteException {
        this.zzf.zzl(location);
    }

    public final void zzK(zzai zzai2) throws RemoteException {
        this.zzf.zzm(zzai2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzL(LocationSettingsRequest locationSettingsRequest, BaseImplementation.ResultHolder<LocationSettingsResult> resultHolder, String string) throws RemoteException {
        this.checkConnected();
        boolean bl = locationSettingsRequest != null;
        Preconditions.checkArgument((boolean)bl, (Object)"locationSettingsRequest can't be null nor empty.");
        bl = resultHolder != null;
        Preconditions.checkArgument((boolean)bl, (Object)"listener can't be null.");
        zzay zzay2 = new zzay(resultHolder);
        ((zzam)this.getService()).zzt(locationSettingsRequest, zzay2, null);
    }

    public final boolean usesClientTelemetry() {
        return true;
    }
}

