/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzl;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionCreator")
public class ActivityTransition
extends AbstractSafeParcelable {
    public static final int ACTIVITY_TRANSITION_ENTER = 0;
    public static final int ACTIVITY_TRANSITION_EXIT = 1;
    @NonNull
    public static final Parcelable.Creator<ActivityTransition> CREATOR;
    @SafeParcelable.Field(id=1, getter="getActivityType")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getTransitionType")
    private final int zzb;

    @SafeParcelable.Constructor
    ActivityTransition(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2) {
        this.zza = n;
        this.zzb = n2;
    }

    public int getActivityType() {
        return this.zza;
    }

    public int getTransitionType() {
        return this.zzb;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb};
        return Objects.hashCode((Object[])objectArray);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ActivityTransition)) {
            return false;
        }
        object = (ActivityTransition)((Object)object);
        return this.zza == ((ActivityTransition)((Object)object)).zza && this.zzb == ((ActivityTransition)((Object)object)).zzb;
    }

    @NonNull
    public String toString() {
        int n = this.zza;
        int n2 = this.zzb;
        StringBuilder stringBuilder = new StringBuilder(75);
        stringBuilder.append("ActivityTransition [mActivityType=");
        stringBuilder.append(n);
        stringBuilder.append(", mTransitionType=");
        stringBuilder.append(n2);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        Preconditions.checkNotNull((Object)parcel);
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.getActivityType());
        SafeParcelWriter.writeInt((Parcel)parcel, (int)2, (int)this.getTransitionType());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    static {
        zzl zzl2;
        CREATOR = zzl2 = new zzl();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zza(int n) {
        boolean bl = n >= 0 ? n <= 1 : false;
        StringBuilder stringBuilder = new StringBuilder(41);
        stringBuilder.append("Transition type ");
        stringBuilder.append(n);
        stringBuilder.append(" is not valid.");
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
    }

    public static class Builder {
        private int zza = -1;
        private int zzb = -1;

        @NonNull
        public Builder setActivityType(int n) {
            this.zza = n;
            return this;
        }

        @NonNull
        public Builder setActivityTransition(int n) {
            ActivityTransition.zza(n);
            this.zzb = n;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public ActivityTransition build() {
            boolean bl = this.zza != -1;
            Preconditions.checkState((boolean)bl, (Object)"Activity type not set.");
            bl = this.zzb != -1;
            Preconditions.checkState((boolean)bl, (Object)"Activity transition type not set.");
            return new ActivityTransition(this.zza, this.zzb);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SupportedActivityTransition {
    }
}

