/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzbe;
import com.google.android.gms.location.zzbo;
import java.util.Arrays;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationAvailabilityCreator")
public final class LocationAvailability
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<LocationAvailability> CREATOR;
    @Deprecated
    @SafeParcelable.Field(id=1, defaultValueUnchecked="LocationAvailability.STATUS_UNKNOWN")
    int zza;
    @Deprecated
    @SafeParcelable.Field(id=2, defaultValueUnchecked="LocationAvailability.STATUS_UNKNOWN")
    int zzb;
    @SafeParcelable.Field(id=3, defaultValueUnchecked="0")
    long zzc;
    @SafeParcelable.Field(id=4, defaultValueUnchecked="LocationAvailability.STATUS_UNSUCCESSFUL")
    int zzd;
    @SafeParcelable.Field(id=5)
    zzbo[] zze;

    public boolean isLocationAvailable() {
        return this.zzd < 1000;
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.zza);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)2, (int)this.zzb);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)3, (long)this.zzc);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)4, (int)this.zzd);
        SafeParcelWriter.writeTypedArray((Parcel)parcel, (int)5, (Parcelable[])this.zze, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zzd, this.zza, this.zzb, this.zzc, this.zze};
        return Objects.hashCode((Object[])objectArray);
    }

    public boolean equals(@NonNull Object object) {
        if (object instanceof LocationAvailability) {
            object = (LocationAvailability)((Object)object);
            return this.zza == ((LocationAvailability)((Object)object)).zza && this.zzb == ((LocationAvailability)((Object)object)).zzb && this.zzc == ((LocationAvailability)((Object)object)).zzc && this.zzd == ((LocationAvailability)((Object)object)).zzd && Arrays.equals((Object[])this.zze, (Object[])((LocationAvailability)((Object)object)).zze);
        }
        return false;
    }

    @NonNull
    public String toString() {
        boolean bl = this.isLocationAvailable();
        StringBuilder stringBuilder = new StringBuilder(48);
        stringBuilder.append("LocationAvailability[isLocationAvailable: ");
        stringBuilder.append(bl);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static boolean hasLocationAvailability(@NonNull Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_AVAILABILITY");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static LocationAvailability extractLocationAvailability(@NonNull Intent object) {
        void var0_3;
        Bundle bundle;
        if (!LocationAvailability.hasLocationAvailability(object)) {
            return null;
        }
        try {
            bundle = object.getExtras();
            if (bundle == null) return var0_3;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        LocationAvailability locationAvailability = (LocationAvailability)bundle.getParcelable("com.google.android.gms.location.EXTRA_LOCATION_AVAILABILITY");
        return var0_3;
    }

    static {
        zzbe zzbe2;
        CREATOR = zzbe2 = new zzbe();
    }

    @SafeParcelable.Constructor
    LocationAvailability(@SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=1) int n2, @SafeParcelable.Param(id=2) int n3, @SafeParcelable.Param(id=3) long l, @SafeParcelable.Param(id=5) zzbo[] zzboArray) {
        this.zzd = n;
        this.zza = n2;
        this.zzb = n3;
        this.zzc = l;
        this.zze = zzboArray;
    }
}

