/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzbj;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzbb;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="GeofencingRequestCreator")
public class GeofencingRequest
extends AbstractSafeParcelable {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    @NonNull
    public static final Parcelable.Creator<GeofencingRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getParcelableGeofences")
    private final List zza;
    @SafeParcelable.Field(id=2, getter="getInitialTrigger")
    @InitialTrigger
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getTag", defaultValue="")
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getContextAttributionTag")
    @Nullable
    private final String zzd;

    @InitialTrigger
    public int getInitialTrigger() {
        return this.zzb;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GeofencingRequest[geofences=");
        stringBuilder.append(this.zza);
        stringBuilder.append(", initialTrigger=");
        stringBuilder.append(this.zzb);
        stringBuilder.append(", tag=");
        stringBuilder.append(this.zzc);
        stringBuilder.append(", attributionTag=");
        stringBuilder.append(this.zzd);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @NonNull
    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zza);
        return arrayList;
    }

    static {
        zzbb zzbb2;
        CREATOR = zzbb2 = new zzbb();
    }

    @SafeParcelable.Constructor
    GeofencingRequest(@SafeParcelable.Param(id=1) List list, @InitialTrigger @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) @Nullable String string2) {
        this.zza = list;
        this.zzb = n;
        this.zzc = string;
        this.zzd = string2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)1, (List)this.zza, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getInitialTrigger());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.zzd, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    @NonNull
    public final GeofencingRequest zza(@Nullable String string) {
        GeofencingRequest geofencingRequest = new GeofencingRequest(this.zza, this.zzb, this.zzc, string);
        return geofencingRequest;
    }

    public static final class Builder {
        private final List zza;
        @InitialTrigger
        private int zzb;
        private String zzc;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addGeofence(@NonNull Geofence geofence) {
            void var1_1;
            Preconditions.checkNotNull((Object)geofence, (Object)"geofence can't be null.");
            Preconditions.checkArgument((boolean)(var1_1 instanceof zzbj), (Object)"Geofence must be created using Geofence.Builder.");
            this.zza.add((zzbj)var1_1);
            return this;
        }

        @NonNull
        public Builder addGeofences(@NonNull List<Geofence> geofences) {
            Iterator iterator;
            if (geofences == null || iterator.isEmpty()) {
                return this;
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Geofence geofence = (Geofence)iterator.next();
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setInitialTrigger(@InitialTrigger int initialTrigger) {
            void var1_1;
            this.zzb = var1_1 & 7;
            return this;
        }

        @NonNull
        public GeofencingRequest build() {
            Preconditions.checkArgument((boolean)(this.zza.isEmpty() ^ true), (Object)"No geofence has been added to this request.");
            GeofencingRequest geofencingRequest = new GeofencingRequest(this.zza, this.zzb, this.zzc, null);
            return geofencingRequest;
        }

        public Builder() {
            ArrayList arrayList;
            this.zza = arrayList = new ArrayList();
            this.zzb = 5;
            this.zzc = "";
        }
    }

    public static @interface InitialTrigger {
    }
}

