/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzbn;
import com.google.android.gms.location.zzbv;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationAvailabilityCreator")
public final class LocationAvailability
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<LocationAvailability> CREATOR;
    @NonNull
    public static final LocationAvailability zza;
    @NonNull
    public static final LocationAvailability zzb;
    @SafeParcelable.Field(id=1, getter="getCellStatus", defaultValueUnchecked="LocationAvailability.STATUS_UNKNOWN")
    private final int zzd;
    @SafeParcelable.Field(id=2, getter="getWifiStatus", defaultValueUnchecked="LocationAvailability.STATUS_UNKNOWN")
    private final int zze;
    @SafeParcelable.Field(id=3, getter="getElapsedRealtimeNs", defaultValueUnchecked="0")
    private final long zzf;
    @SafeParcelable.Field(id=4, defaultValueUnchecked="LocationAvailability.STATUS_UNSUCCESSFUL")
    int zzc;
    @SafeParcelable.Field(id=5, getter="getBatchedStatus")
    private final zzbv[] zzg;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zzc};
        return Objects.hashCode((Object[])objectArray);
    }

    @Nullable
    public static LocationAvailability extractLocationAvailability(@NonNull Intent intent) {
        if (!LocationAvailability.hasLocationAvailability(intent)) {
            return null;
        }
        try {
            Object object;
            object = (LocationAvailability)object.getParcelableExtra("com.google.android.gms.location.EXTRA_LOCATION_AVAILABILITY");
            return object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @NonNull
    public String toString() {
        boolean bl = this.isLocationAvailable();
        StringBuilder stringBuilder = new StringBuilder(27);
        stringBuilder.append("LocationAvailability[");
        stringBuilder.append(bl);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        Object object;
        zza = object = new LocationAvailability(0, 1, 1, 0L, null, true);
        zzb = object = new LocationAvailability(1000, 1, 1, 0L, null, false);
        object = new zzbn();
        CREATOR = object;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.zzd);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.zze);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.zzf);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.zzc);
        SafeParcelWriter.writeTypedArray((Parcel)var1_1, (int)5, (Parcelable[])this.zzg, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)6, (boolean)this.isLocationAvailable());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof LocationAvailability) {
            LocationAvailability locationAvailability;
            locationAvailability = locationAvailability;
            return this.zzd == locationAvailability.zzd && this.zze == locationAvailability.zze && this.zzf == locationAvailability.zzf && this.zzc == locationAvailability.zzc && Arrays.equals((Object[])this.zzg, (Object[])locationAvailability.zzg);
        }
        return false;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public static boolean hasLocationAvailability(@Nullable Intent intent) {
        Intent intent2;
        return intent != null && intent2.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_AVAILABILITY");
    }

    public boolean isLocationAvailable() {
        return this.zzc < 1000;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    LocationAvailability(@SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=1) int n2, @SafeParcelable.Param(id=2) int n3, @SafeParcelable.Param(id=3) long l, @SafeParcelable.Param(id=5) zzbv[] zzbvArray, @SafeParcelable.Param(id=6) boolean bl) {
        n = n < 1000 ? 0 : 1000;
        this.zzc = n;
        this.zzd = n2;
        this.zze = n3;
        this.zzf = l;
        this.zzg = zzbvArray;
    }
}

