/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.IStatusCallback;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.location.zzcf;
import com.google.android.gms.internal.location.zzcg;
import com.google.android.gms.internal.location.zzch;
import com.google.android.gms.internal.location.zzci;
import com.google.android.gms.internal.location.zzcj;
import com.google.android.gms.internal.location.zzck;
import com.google.android.gms.internal.location.zzcl;
import com.google.android.gms.internal.location.zzcm;
import com.google.android.gms.internal.location.zzcn;
import com.google.android.gms.internal.location.zzco;
import com.google.android.gms.internal.location.zzcp;
import com.google.android.gms.internal.location.zzcs;
import com.google.android.gms.internal.location.zzcw;
import com.google.android.gms.internal.location.zzcz;
import com.google.android.gms.internal.location.zzdb;
import com.google.android.gms.internal.location.zzdd;
import com.google.android.gms.internal.location.zzdf;
import com.google.android.gms.internal.location.zzdx;
import com.google.android.gms.internal.location.zzn;
import com.google.android.gms.internal.location.zzo;
import com.google.android.gms.location.CurrentLocationRequest;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LastLocationRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzm;
import com.google.android.gms.location.zzr;
import com.google.android.gms.location.zzu;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnTokenCanceledListener;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.List;
import java.util.concurrent.Executor;

public final class zzda
extends GmsClient {
    private final SimpleArrayMap zzf;
    private final SimpleArrayMap zzg;
    private final SimpleArrayMap zzh;
    public static final /* synthetic */ int zze;

    public final int getMinApkVersion() {
        return 11717000;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        void var0_2;
        void var1_6;
        if (var1_6 == null) {
            return var0_2;
        }
        IInterface iInterface = var1_6.queryLocalInterface("com.google.android.gms.location.internal.IGoogleLocationManagerService");
        if (iInterface instanceof zzo) {
            zzo zzo2 = (zzo)iInterface;
            return var0_2;
        }
        zzn zzn2 = new zzn((IBinder)var1_6);
        return var0_2;
    }

    public final LocationAvailability zzp() throws RemoteException {
        return ((zzo)this.getService()).zzf(this.getContext().getPackageName());
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.location.internal.IGoogleLocationManagerService";
    }

    protected final String getStartServiceAction() {
        return "com.google.android.location.internal.GoogleLocationManagerService.START";
    }

    public zzda(Context context, Looper looper, ClientSettings clientSettings, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 23, clientSettings, connectionCallbacks, onConnectionFailedListener);
        super();
        this.zzf = context;
        super();
        this.zzg = context;
        super();
        this.zzh = context;
    }

    public final void zzq(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, TaskCompletionSource taskCompletionSource) throws RemoteException {
        Preconditions.checkNotNull((Object)((Object)geofencingRequest), (Object)"geofencingRequest can't be null.");
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        Object object = object.getService();
        object = (zzo)object;
        zzci zzci2 = new zzci(taskCompletionSource);
        object.zzg(geofencingRequest, pendingIntent, zzci2);
    }

    public final void zzr(TaskCompletionSource taskCompletionSource) throws RemoteException {
        Object object = object.getService();
        object = (zzo)object;
        zzcn zzcn2 = new zzcn(null, taskCompletionSource);
        object.zzi(zzcn2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzs(CurrentLocationRequest object, CancellationToken cancellationToken, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zzda2.getContext();
        if (zzda2.zzE(zzm.zze)) {
            IInterface iInterface = zzda2.getService();
            iInterface = (zzo)iInterface;
            zzcm zzcm2 = new zzcm(zzda2, taskCompletionSource);
            zzda zzda2 = iInterface.zze((CurrentLocationRequest)((Object)object), zzcm2);
            if (cancellationToken == null) return;
            object = new zzcf((ICancelToken)zzda2);
            cancellationToken.onCanceledRequested((OnTokenCanceledListener)object);
            return;
        }
        Object object2 = new zzcj(zzda2, taskCompletionSource);
        object2 = ListenerHolders.createListenerHolder((Object)object2, (Executor)zzdx.zza(), (String)"GetCurrentLocation");
        ListenerHolder.ListenerKey listenerKey = object2.getListenerKey();
        listenerKey.getClass();
        zzck zzck2 = new zzck(zzda2, (ListenerHolder)object2, taskCompletionSource);
        object2 = new TaskCompletionSource();
        LocationRequest.Builder builder = new LocationRequest.Builder(((CurrentLocationRequest)((Object)object)).getPriority(), 0L);
        builder.setMinUpdateIntervalMillis(0L);
        builder.setDurationMillis(((CurrentLocationRequest)((Object)object)).getDurationMillis());
        builder.setGranularity(((CurrentLocationRequest)((Object)object)).getGranularity());
        builder.setMaxUpdateAgeMillis(((CurrentLocationRequest)((Object)object)).getMaxUpdateAgeMillis());
        builder.zza(((CurrentLocationRequest)((Object)object)).zze());
        builder.zzc(((CurrentLocationRequest)((Object)object)).zza());
        builder.setWaitForAccurateLocation(true);
        builder.zzb(((CurrentLocationRequest)((Object)object)).zzd());
        builder.zzd(((CurrentLocationRequest)((Object)object)).zzb());
        zzda2.zzu(zzck2, builder.build(), (TaskCompletionSource)object2);
        object = object2.getTask();
        object2 = new zzcg(taskCompletionSource);
        object.addOnCompleteListener((OnCompleteListener)object2);
        if (cancellationToken == null) {
            return;
        }
        object = new zzch(zzda2, listenerKey);
        cancellationToken.onCanceledRequested((OnTokenCanceledListener)object);
    }

    public final void zzt(LastLocationRequest lastLocationRequest, TaskCompletionSource taskCompletionSource) throws RemoteException {
        this.getContext();
        if (this.zzE(zzm.zzf)) {
            IInterface iInterface = this.getService();
            iInterface = (zzo)iInterface;
            zzcm zzcm2 = new zzcm(this, taskCompletionSource);
            iInterface.zzj(lastLocationRequest, zzcm2);
            return;
        }
        taskCompletionSource.setResult((Object)((zzo)this.getService()).zzd());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onConnectionSuspended(int n) {
        super.onConnectionSuspended(n);
        SimpleArrayMap simpleArrayMap = this.zzf;
        synchronized (simpleArrayMap) {
            this.zzf.clear();
        }
        simpleArrayMap = this.zzg;
        synchronized (simpleArrayMap) {
            this.zzg.clear();
        }
        simpleArrayMap = this.zzh;
        synchronized (simpleArrayMap) {
            this.zzh.clear();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzu(zzcs object, LocationRequest object2, TaskCompletionSource object3) throws RemoteException {
        Object object4 = object.zza();
        Object object5 = object4.getListenerKey();
        object5.getClass();
        boolean bl = ((zzda)((Object)zzo3)).zzE(zzm.zzj);
        SimpleArrayMap simpleArrayMap = ((zzda)((Object)zzo3)).zzg;
        synchronized (simpleArrayMap) {
            zzcw zzcw2 = (zzcw)((zzda)((Object)zzo3)).zzg.get(object5);
            if (zzcw2 == null || bl) {
                object4 = new zzcw((zzcs)object);
                ((zzda)((Object)zzo3)).zzg.put(object5, object4);
                object = zzcw2;
            } else {
                zzcw2.zzg((ListenerHolder)object4);
                object = null;
                object4 = zzcw2;
            }
            zzo3.getContext();
            object5 = object5.toIdString();
            if (bl) {
                zzo zzo2 = (zzo)zzo3.getService();
                object = zzdb.zzb((IInterface)object, (zzr)object4, null, (String)object5);
                object4 = new zzcl((zzda)((Object)zzo3), null, (TaskCompletionSource)object3);
                zzo2.zzk((zzdb)((Object)object), (LocationRequest)((Object)object2), (IStatusCallback)object4);
            } else {
                zzo zzo3 = (zzo)zzo3.getService();
                object = new LocationRequest.Builder((LocationRequest)((Object)object2));
                ((LocationRequest.Builder)object).zzb(null);
                object = ((LocationRequest.Builder)object).build();
                object = zzdd.zza(null, (LocationRequest)((Object)object));
                object2 = new zzcp((TaskCompletionSource)object3, (zzr)object4);
                object3 = new zzdf(1, (zzdd)((Object)object), null, (IBinder)object4, null, (IBinder)object2, (String)object5);
                zzo3.zzz((zzdf)((Object)object3));
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzv(zzcs object, LocationRequest object2, TaskCompletionSource object3) throws RemoteException {
        Object object4 = object.zza();
        Object object5 = object4.getListenerKey();
        object5.getClass();
        boolean bl = ((zzda)((Object)zzo3)).zzE(zzm.zzj);
        SimpleArrayMap simpleArrayMap = ((zzda)((Object)zzo3)).zzf;
        synchronized (simpleArrayMap) {
            zzcz zzcz2 = (zzcz)((zzda)((Object)zzo3)).zzf.get(object5);
            if (zzcz2 == null || bl) {
                object4 = new zzcz((zzcs)object);
                ((zzda)((Object)zzo3)).zzf.put(object5, object4);
                object = zzcz2;
            } else {
                zzcz2.zzf((ListenerHolder)object4);
                object = null;
                object4 = zzcz2;
            }
            zzo3.getContext();
            object5 = object5.toIdString();
            if (bl) {
                zzo zzo2 = (zzo)zzo3.getService();
                object = zzdb.zzc((IInterface)object, (zzu)object4, null, (String)object5);
                object4 = new zzcl((zzda)((Object)zzo3), null, (TaskCompletionSource)object3);
                zzo2.zzk((zzdb)((Object)object), (LocationRequest)((Object)object2), (IStatusCallback)object4);
            } else {
                zzo zzo3 = (zzo)zzo3.getService();
                object = new LocationRequest.Builder((LocationRequest)((Object)object2));
                ((LocationRequest.Builder)object).zzb(null);
                object = ((LocationRequest.Builder)object).build();
                object = zzdd.zza(null, (LocationRequest)((Object)object));
                object2 = new zzco((TaskCompletionSource)object3, (zzu)object4);
                object3 = new zzdf(1, (zzdd)((Object)object), (IBinder)object4, null, null, (IBinder)object2, (String)object5);
                zzo3.zzz((zzdf)((Object)object3));
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzw(PendingIntent object, LocationRequest abstractSafeParcelable, TaskCompletionSource object2) throws RemoteException {
        object3.getContext();
        if (((zzda)((Object)object3)).zzE(zzm.zzj)) {
            IInterface iInterface = object3.getService();
            iInterface = (zzo)iInterface;
            object = zzdb.zza(object, null, null);
            zzcl zzcl2 = new zzcl((zzda)((Object)object3), null, (TaskCompletionSource)object2);
            iInterface.zzk((zzdb)((Object)object), (LocationRequest)abstractSafeParcelable, (IStatusCallback)zzcl2);
            return;
        }
        Object object3 = object3.getService();
        object3 = (zzo)object3;
        Object object4 = new LocationRequest.Builder((LocationRequest)abstractSafeParcelable);
        ((LocationRequest.Builder)object4).zzb(null);
        abstractSafeParcelable = ((LocationRequest.Builder)object4).build();
        abstractSafeParcelable = zzdd.zza(null, (LocationRequest)abstractSafeParcelable);
        object4 = new zzcn(null, (TaskCompletionSource)object2);
        int n = object.hashCode();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PendingIntent@");
        stringBuilder.append(n);
        object2 = new zzdf(1, (zzdd)abstractSafeParcelable, null, null, (PendingIntent)object, (IBinder)object4, stringBuilder.toString());
        object3.zzz((zzdf)((Object)object2));
    }

    public final void zzx(PendingIntent pendingIntent, TaskCompletionSource taskCompletionSource) throws RemoteException {
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        IInterface iInterface = this.getService();
        iInterface = (zzo)iInterface;
        zzci zzci2 = new zzci(taskCompletionSource);
        iInterface.zzn(pendingIntent, zzci2, this.getContext().getPackageName());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzy(List stringArray, TaskCompletionSource taskCompletionSource) throws RemoteException {
        boolean bl = stringArray != null ? !stringArray.isEmpty() : false;
        Preconditions.checkArgument((boolean)bl, (Object)"geofenceRequestIds can't be null nor empty.");
        IInterface iInterface = new IInterface[]{};
        stringArray = stringArray.toArray((T[])iInterface);
        iInterface = this.getService();
        iInterface = (zzo)iInterface;
        zzci zzci2 = new zzci(taskCompletionSource);
        iInterface.zzo(stringArray, zzci2, this.getContext().getPackageName());
    }

    public final void zzz(Location location, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzE(zzm.zzh)) {
            IInterface iInterface = this.getService();
            iInterface = (zzo)iInterface;
            zzcl zzcl2 = new zzcl(this, null, taskCompletionSource);
            iInterface.zzv(location, (IStatusCallback)zzcl2);
            return;
        }
        ((zzo)this.getService()).zzu(location);
        taskCompletionSource.setResult(null);
    }

    public final void zzA(boolean bl, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzE(zzm.zzg)) {
            IInterface iInterface = this.getService();
            iInterface = (zzo)iInterface;
            zzcl zzcl2 = new zzcl(this, null, taskCompletionSource);
            iInterface.zzx(bl, (IStatusCallback)zzcl2);
            return;
        }
        ((zzo)this.getService()).zzw(bl);
        taskCompletionSource.setResult(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzB(ListenerHolder.ListenerKey object, boolean bl, TaskCompletionSource taskCompletionSource) throws RemoteException {
        SimpleArrayMap simpleArrayMap = ((zzda)((Object)zzo3)).zzg;
        synchronized (simpleArrayMap) {
            object = (zzcw)((zzda)((Object)zzo3)).zzg.remove(object);
            if (object == null) {
                taskCompletionSource.setResult((Object)Boolean.FALSE);
                return;
            }
            object.zzh();
            if (bl) {
                bl = ((zzda)((Object)zzo3)).zzE(zzm.zzj);
                if (bl) {
                    zzo zzo2 = (zzo)zzo3.getService();
                    object = zzdb.zzb(null, (zzr)object, null, null);
                    Boolean bl2 = Boolean.TRUE;
                    zzcl zzcl2 = new zzcl((zzda)((Object)zzo3), bl2, taskCompletionSource);
                    zzo2.zzy((zzdb)((Object)object), (IStatusCallback)zzcl2);
                } else {
                    zzo zzo3 = (zzo)zzo3.getService();
                    Object object2 = Boolean.TRUE;
                    zzcn zzcn2 = new zzcn(object2, taskCompletionSource);
                    object2 = new zzdf(2, null, null, (IBinder)object, null, (IBinder)zzcn2, null);
                    zzo3.zzz((zzdf)((Object)object2));
                }
            } else {
                taskCompletionSource.setResult((Object)Boolean.TRUE);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzC(ListenerHolder.ListenerKey object, boolean bl, TaskCompletionSource taskCompletionSource) throws RemoteException {
        SimpleArrayMap simpleArrayMap = ((zzda)((Object)zzo3)).zzf;
        synchronized (simpleArrayMap) {
            object = (zzcz)((zzda)((Object)zzo3)).zzf.remove(object);
            if (object == null) {
                taskCompletionSource.setResult((Object)Boolean.FALSE);
                return;
            }
            object.zzg();
            if (bl) {
                bl = ((zzda)((Object)zzo3)).zzE(zzm.zzj);
                if (bl) {
                    zzo zzo2 = (zzo)zzo3.getService();
                    object = zzdb.zzc(null, (zzu)object, null, null);
                    Boolean bl2 = Boolean.TRUE;
                    zzcl zzcl2 = new zzcl((zzda)((Object)zzo3), bl2, taskCompletionSource);
                    zzo2.zzy((zzdb)((Object)object), (IStatusCallback)zzcl2);
                } else {
                    zzo zzo3 = (zzo)zzo3.getService();
                    Object object2 = Boolean.TRUE;
                    zzcn zzcn2 = new zzcn(object2, taskCompletionSource);
                    object2 = new zzdf(2, null, (IBinder)object, null, null, (IBinder)zzcn2, null);
                    zzo3.zzz((zzdf)((Object)object2));
                }
            } else {
                taskCompletionSource.setResult((Object)Boolean.TRUE);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzD(PendingIntent object, TaskCompletionSource object2, Object object3) throws RemoteException {
        if (((zzda)((Object)object4)).zzE(zzm.zzj)) {
            object3 = object4.getService();
            object3 = (zzo)object3;
            object = zzdb.zza(object, null, null);
            zzcl zzcl2 = new zzcl((zzda)((Object)object4), null, (TaskCompletionSource)object2);
            object3.zzy((zzdb)((Object)object), (IStatusCallback)zzcl2);
            return;
        }
        Object object4 = object4.getService();
        object4 = (zzo)object4;
        object3 = new zzcn(null, (TaskCompletionSource)object2);
        object2 = new zzdf(2, null, null, null, (PendingIntent)object, (IBinder)object3, null);
        object4.zzz((zzdf)((Object)object2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean zzE(Feature feature) {
        Feature[] featureArray = this.getAvailableFeatures();
        if (featureArray == null) {
            return false;
        }
        int n = featureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Feature feature2 = featureArray[n2];
            if (feature.getName().equals(feature2.getName())) {
                Feature feature3 = feature2;
                if (feature3 == null) {
                    return false;
                }
                if (feature3.getVersion() < feature.getVersion()) return false;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final boolean usesClientTelemetry() {
        return true;
    }

    public final Feature[] getApiFeatures() {
        return zzm.zzl;
    }
}

