/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.ActivityTransitionEvent;
import com.google.android.gms.location.zzi;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionResultCreator")
public class ActivityTransitionResult
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ActivityTransitionResult> CREATOR;
    @SafeParcelable.Field(id=1, getter="getTransitionEvents")
    private final List zza;
    @SafeParcelable.Field(id=2, getter="getExtras")
    @Nullable
    private Bundle zzb = null;

    public int hashCode() {
        return ((Object)this.zza).hashCode();
    }

    @Nullable
    public static ActivityTransitionResult extractResult(@NonNull Intent intent) {
        Intent intent2;
        if (!ActivityTransitionResult.hasResult(intent)) {
            return null;
        }
        return (ActivityTransitionResult)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent2, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_RESULT", CREATOR);
    }

    @NonNull
    public List<ActivityTransitionEvent> getTransitionEvents() {
        return this.zza;
    }

    static {
        zzi zzi2;
        CREATOR = zzi2 = new zzi();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ActivityTransitionResult(@SafeParcelable.Param(id=1) @NonNull List<ActivityTransitionEvent> transitionEvents) {
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"transitionEvents list can't be null.");
        if (!var1_1.isEmpty()) {
            for (int i = 1; i < var1_1.size(); ++i) {
                boolean bl = ((ActivityTransitionEvent)((Object)var1_1.get(i))).getElapsedRealTimeNanos() >= ((ActivityTransitionEvent)((Object)var1_1.get(i + -1))).getElapsedRealTimeNanos();
                Preconditions.checkArgument((boolean)bl);
            }
        }
        this.zza = Collections.unmodifiableList(var1_1);
    }

    @ShowFirstParty
    @SafeParcelable.Constructor
    public ActivityTransitionResult(@SafeParcelable.Param(id=1) @NonNull List list, @Nullable @SafeParcelable.Param(id=2) Bundle bundle) {
        this(list);
        this.zzb = bundle;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        Preconditions.checkNotNull((Object)dest);
        n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)1, this.getTransitionEvents(), (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)var1_1, (int)2, (Bundle)this.zzb, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object o) {
        void var1_1;
        if (this == var1_1) {
            return true;
        }
        if (var1_1 == null || ((Object)((Object)this)).getClass() != var1_1.getClass()) {
            return false;
        }
        return ((Object)this.zza).equals(((ActivityTransitionResult)var1_1).zza);
    }

    public static boolean hasResult(@Nullable Intent intent) {
        Intent intent2;
        if (intent == null) {
            return false;
        }
        return intent2.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_RESULT");
    }
}

