/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.WorkSource;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.WorkSourceUtil;
import com.google.android.gms.internal.location.zzd;
import com.google.android.gms.internal.location.zzdj;
import com.google.android.gms.location.zzae;
import com.google.android.gms.location.zzai;
import com.google.android.gms.location.zzj;
import com.google.android.gms.location.zzo;
import org.checkerframework.dataflow.qual.Pure;

@SafeParcelable.Class(creator="CurrentLocationRequestCreator")
public final class CurrentLocationRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<CurrentLocationRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getMaxUpdateAgeMillis", defaultValueUnchecked="Long.MAX_VALUE")
    private final long zza;
    @SafeParcelable.Field(id=2, getter="getGranularity", defaultValueUnchecked="Granularity.GRANULARITY_PERMISSION_LEVEL")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getPriority", defaultValueUnchecked="Priority.PRIORITY_BALANCED_POWER_ACCURACY")
    private final int zzc;
    @SafeParcelable.Field(id=4, getter="getDurationMillis", defaultValueUnchecked="Long.MAX_VALUE")
    private final long zzd;
    @SafeParcelable.Field(id=5, getter="isBypass", defaultValue="false")
    private final boolean zze;
    @SafeParcelable.Field(id=7, getter="getThrottleBehavior", defaultValueUnchecked="ThrottleBehavior.THROTTLE_BACKGROUND")
    private final int zzf;
    @SafeParcelable.Field(id=8, getter="getModuleId")
    @Nullable
    private final String zzg;
    @SafeParcelable.Field(id=6, getter="getWorkSource", defaultValueUnchecked="new android.os.WorkSource()")
    private final WorkSource zzh;
    @SafeParcelable.Field(id=9, getter="getImpersonation")
    @Nullable
    private final zzd zzi;

    @Pure
    public int getGranularity() {
        return this.zzb;
    }

    @Pure
    public int getPriority() {
        return this.zzc;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc, this.zzd};
        return Objects.hashCode((Object[])objectArray);
    }

    @Pure
    public long getDurationMillis() {
        return this.zzd;
    }

    @Pure
    public long getMaxUpdateAgeMillis() {
        return this.zza;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CurrentLocationRequest[");
        stringBuilder.append(zzae.zzb(this.zzc));
        if (this.zza != Long.MAX_VALUE) {
            stringBuilder.append(", maxAge=");
            zzdj.zzb(this.zza, stringBuilder);
        }
        if (this.zzd != Long.MAX_VALUE) {
            stringBuilder.append(", duration=");
            stringBuilder.append(this.zzd);
            stringBuilder.append("ms");
        }
        if (this.zzb != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(zzo.zzb(this.zzb));
        }
        if (this.zze) {
            stringBuilder.append(", bypass");
        }
        if (this.zzf != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(zzai.zza(this.zzf));
        }
        if (this.zzg != null) {
            stringBuilder.append(", moduleId=");
            stringBuilder.append(this.zzg);
        }
        if (!WorkSourceUtil.isEmpty((WorkSource)this.zzh)) {
            stringBuilder.append(", workSource=");
            stringBuilder.append(this.zzh);
        }
        if (this.zzi != null) {
            stringBuilder.append(", impersonation=");
            stringBuilder.append((Object)this.zzi);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        zzj zzj2;
        CREATOR = zzj2 = new zzj();
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)1, (long)this.getMaxUpdateAgeMillis());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getGranularity());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getPriority());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)4, (long)this.getDurationMillis());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)5, (boolean)this.zze);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)6, (Parcelable)this.zzh, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)7, (int)this.zzf);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)this.zzg, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)9, (Parcelable)this.zzi, (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object object) {
        CurrentLocationRequest currentLocationRequest;
        if (!(object instanceof CurrentLocationRequest)) {
            return false;
        }
        currentLocationRequest = currentLocationRequest;
        return this.zza == currentLocationRequest.zza && this.zzb == currentLocationRequest.zzb && this.zzc == currentLocationRequest.zzc && this.zzd == currentLocationRequest.zzd && this.zze == currentLocationRequest.zze && this.zzf == currentLocationRequest.zzf && Objects.equal((Object)this.zzg, (Object)currentLocationRequest.zzg) && Objects.equal((Object)this.zzh, (Object)currentLocationRequest.zzh) && Objects.equal((Object)((Object)this.zzi), (Object)((Object)currentLocationRequest.zzi));
    }

    @Pure
    public final int zza() {
        return this.zzf;
    }

    @Pure
    @NonNull
    public final WorkSource zzb() {
        return this.zzh;
    }

    @Pure
    @Nullable
    public final zzd zzc() {
        return this.zzi;
    }

    @Deprecated
    @Pure
    @Nullable
    public final String zzd() {
        return this.zzg;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    CurrentLocationRequest(@SafeParcelable.Param(id=1) long l, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) long l2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=7) int n3, @SafeParcelable.Param(id=8) @Nullable String string, @SafeParcelable.Param(id=6) WorkSource workSource, @SafeParcelable.Param(id=9) @Nullable zzd zzd2) {
        boolean bl2 = Build.VERSION.SDK_INT >= 30 ? string == null : true;
        Preconditions.checkArgument((boolean)bl2);
        this.zza = l;
        this.zzb = n;
        this.zzc = n2;
        this.zzd = l2;
        this.zze = bl;
        this.zzf = n3;
        this.zzg = string;
        this.zzh = workSource;
        this.zzi = zzd2;
    }

    @Pure
    public final boolean zze() {
        return this.zze;
    }

    public static final class Builder {
        private long zza;
        private int zzb;
        private int zzc;
        private long zzd;
        private boolean zze;
        private int zzf;
        @Nullable
        private String zzg;
        @Nullable
        private WorkSource zzh;
        @Nullable
        private zzd zzi;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setDurationMillis(long durationMillis) {
            void var1_1;
            boolean bl = durationMillis > 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"durationMillis must be greater than 0");
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGranularity(int granularity) {
            void var1_1;
            zzo.zza(granularity);
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdateAgeMillis(long maxUpdateAgeMillis) {
            void var1_1;
            boolean bl = maxUpdateAgeMillis >= 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdateAgeMillis must be greater than or equal to 0");
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPriority(int priority) {
            void var1_1;
            zzae.zza(priority);
            this.zzc = var1_1;
            return this;
        }

        @NonNull
        public CurrentLocationRequest build() {
            long l = this.zza;
            int n = this.zzb;
            int n2 = this.zzc;
            long l2 = this.zzd;
            boolean bl = this.zze;
            int n3 = this.zzf;
            String string = this.zzg;
            WorkSource workSource = new WorkSource(this.zzh);
            CurrentLocationRequest currentLocationRequest = new CurrentLocationRequest(l, n, n2, l2, bl, n3, string, workSource, this.zzi);
            return currentLocationRequest;
        }

        public Builder() {
            this.zza = 60000L;
            this.zzb = 0;
            this.zzc = 102;
            this.zzd = Long.MAX_VALUE;
            this.zze = false;
            this.zzf = 0;
            this.zzg = null;
            this.zzh = null;
            this.zzi = null;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull CurrentLocationRequest request) {
            WorkSource workSource;
            void var1_1;
            this.zza = var1_1.getMaxUpdateAgeMillis();
            this.zzb = var1_1.getGranularity();
            this.zzc = var1_1.getPriority();
            this.zzd = var1_1.getDurationMillis();
            this.zze = var1_1.zze();
            this.zzf = var1_1.zza();
            this.zzg = var1_1.zzd();
            this.zzh = workSource = new WorkSource(var1_1.zzb());
            this.zzi = var1_1.zzc();
        }
    }
}

