/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.WorkSource;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.WorkSourceUtil;
import com.google.android.gms.internal.location.zzd;
import com.google.android.gms.internal.location.zzdj;
import com.google.android.gms.location.zzae;
import com.google.android.gms.location.zzai;
import com.google.android.gms.location.zzo;
import com.google.android.gms.location.zzx;
import org.checkerframework.dataflow.qual.Pure;

@SafeParcelable.Reserved(value={4, 5, 1000})
@SafeParcelable.Class(creator="LocationRequestCreator")
public final class LocationRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<LocationRequest> CREATOR;
    @Deprecated
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    @Deprecated
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    @Deprecated
    public static final int PRIORITY_LOW_POWER = 104;
    @Deprecated
    public static final int PRIORITY_NO_POWER = 105;
    @SafeParcelable.Field(id=1, getter="getPriority", defaultValueUnchecked="Priority.PRIORITY_BALANCED_POWER_ACCURACY")
    private int zza;
    @SafeParcelable.Field(id=2, getter="getIntervalMillis", defaultValue="3600000")
    private long zzb;
    @SafeParcelable.Field(id=3, getter="getMinUpdateIntervalMillis", defaultValue="600000")
    private long zzc;
    @SafeParcelable.Field(id=8, getter="getMaxUpdateDelayMillis", defaultValue="0")
    private long zzd;
    @SafeParcelable.Field(id=10, getter="getDurationMillis", defaultValueUnchecked="Long.MAX_VALUE")
    private long zze;
    @SafeParcelable.Field(id=6, getter="getMaxUpdates", defaultValueUnchecked="Integer.MAX_VALUE")
    private int zzf;
    @SafeParcelable.Field(id=7, getter="getMinUpdateDistanceMeters", defaultValue="0")
    private float zzg;
    @SafeParcelable.Field(id=9, getter="isWaitForAccurateLocation", defaultValue="false")
    private boolean zzh;
    @SafeParcelable.Field(id=11, getter="getMaxUpdateAgeMillis", defaultValueUnchecked="-1")
    private long zzi;
    @SafeParcelable.Field(id=12, getter="getGranularity", defaultValueUnchecked="Granularity.GRANULARITY_PERMISSION_LEVEL")
    private final int zzj;
    @SafeParcelable.Field(id=13, getter="getThrottleBehavior", defaultValueUnchecked="ThrottleBehavior.THROTTLE_BACKGROUND")
    private final int zzk;
    @SafeParcelable.Field(id=14, getter="getModuleId")
    @Nullable
    private final String zzl;
    @SafeParcelable.Field(id=15, getter="isBypass", defaultValue="false")
    private final boolean zzm;
    @SafeParcelable.Field(id=16, getter="getWorkSource", defaultValueUnchecked="new android.os.WorkSource()")
    private final WorkSource zzn;
    @SafeParcelable.Field(id=17, getter="getImpersonation")
    @Nullable
    private final zzd zzo;

    @Pure
    public float getMinUpdateDistanceMeters() {
        return this.zzg;
    }

    @Deprecated
    @Pure
    public float getSmallestDisplacement() {
        return this.getMinUpdateDistanceMeters();
    }

    @Pure
    public int getGranularity() {
        return this.zzj;
    }

    @Pure
    public int getMaxUpdates() {
        return this.zzf;
    }

    @Deprecated
    @Pure
    public int getNumUpdates() {
        return this.getMaxUpdates();
    }

    @Pure
    public int getPriority() {
        return this.zza;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc, this.zzn};
        return Objects.hashCode((Object[])objectArray);
    }

    @Pure
    public long getDurationMillis() {
        return this.zze;
    }

    @Deprecated
    @Pure
    public long getExpirationTime() {
        long l;
        long l2;
        long l3 = SystemClock.elapsedRealtime();
        if (((l3 ^ (l2 = l3 + (l = this.zze))) & (l ^ l2)) < 0L) {
            return Long.MAX_VALUE;
        }
        return l2;
    }

    @Deprecated
    @Pure
    public long getFastestInterval() {
        return this.getMinUpdateIntervalMillis();
    }

    @Deprecated
    @Pure
    public long getInterval() {
        return this.getIntervalMillis();
    }

    @Pure
    public long getIntervalMillis() {
        return this.zzb;
    }

    @Pure
    public long getMaxUpdateAgeMillis() {
        return this.zzi;
    }

    @Pure
    public long getMaxUpdateDelayMillis() {
        return this.zzd;
    }

    @Deprecated
    @Pure
    public long getMaxWaitTime() {
        return Math.max(this.zzd, this.zzb);
    }

    @Pure
    public long getMinUpdateIntervalMillis() {
        return this.zzc;
    }

    @Deprecated
    @NonNull
    public static LocationRequest create() {
        WorkSource workSource = new WorkSource();
        LocationRequest locationRequest = new LocationRequest(102, 3600000L, 600000L, 0L, Long.MAX_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE, 0.0f, true, 3600000L, 0, 0, null, false, workSource, null);
        return locationRequest;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Deprecated
    @NonNull
    public LocationRequest setExpirationDuration(long durationMillis) {
        void var1_1;
        boolean bl = durationMillis > 0L;
        Preconditions.checkArgument((boolean)bl, (Object)"durationMillis must be greater than 0");
        this.zze = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public LocationRequest setExpirationTime(long elapsedRealtime) {
        void var1_1;
        this.zze = Math.max(1L, (long)(var1_1 - SystemClock.elapsedRealtime()));
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Deprecated
    @NonNull
    public LocationRequest setFastestInterval(long fastestIntervalMillis) {
        void var1_1;
        boolean bl = fastestIntervalMillis >= 0L;
        Object[] objectArray = new Object[]{(long)var1_1};
        Preconditions.checkArgument((boolean)bl, (String)"illegal fastest interval: %d", (Object[])objectArray);
        this.zzc = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Deprecated
    @NonNull
    public LocationRequest setInterval(long intervalMillis) {
        void var1_1;
        boolean bl = intervalMillis >= 0L;
        Preconditions.checkArgument((boolean)bl, (Object)"intervalMillis must be greater than or equal to 0");
        long l = this.zzc;
        long l2 = this.zzb;
        if (l == l2 / 6L) {
            this.zzc = var1_1 / 6L;
        }
        if (this.zzi == l2) {
            this.zzi = var1_1;
        }
        this.zzb = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Deprecated
    @NonNull
    public LocationRequest setMaxWaitTime(long maxWaitTimeMillis) {
        void var1_1;
        boolean bl = maxWaitTimeMillis >= 0L;
        Object[] objectArray = new Object[]{(long)var1_1};
        Preconditions.checkArgument((boolean)bl, (String)"illegal max wait time: %d", (Object[])objectArray);
        this.zzd = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public LocationRequest setNumUpdates(int maxUpdates) {
        void var1_1;
        if (maxUpdates <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("invalid numUpdates: ");
            stringBuilder.append((int)var1_1);
            Object object = new IllegalArgumentException(stringBuilder.toString());
            throw object;
        }
        object.zzf = var1_1;
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public LocationRequest setPriority(int priority) {
        void var1_1;
        zzae.zza(priority);
        this.zza = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        void var1_1;
        if (smallestDisplacementMeters < 0.0f) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("invalid displacement: ");
            stringBuilder.append((float)var1_1);
            Object object = new IllegalArgumentException(stringBuilder.toString());
            throw object;
        }
        object.zzg = var1_1;
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public LocationRequest setWaitForAccurateLocation(boolean waitForAccurateLocation) {
        void var1_1;
        this.zzh = var1_1;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[");
        if (this.isPassive()) {
            stringBuilder.append(zzae.zzb(this.zza));
        } else {
            stringBuilder.append("@");
            if (this.isBatched()) {
                zzdj.zzb(this.zzb, stringBuilder);
                stringBuilder.append("/");
                zzdj.zzb(this.zzd, stringBuilder);
            } else {
                zzdj.zzb(this.zzb, stringBuilder);
            }
            stringBuilder.append(" ");
            stringBuilder.append(zzae.zzb(this.zza));
        }
        if (this.isPassive() || this.zzc != this.zzb) {
            stringBuilder.append(", minUpdateInterval=");
            stringBuilder.append(LocationRequest.zzf(this.zzc));
        }
        if ((double)this.zzg > 0.0) {
            stringBuilder.append(", minUpdateDistance=");
            stringBuilder.append(this.zzg);
        }
        if (this.isPassive() ? this.zzi != Long.MAX_VALUE : this.zzi != this.zzb) {
            stringBuilder.append(", maxUpdateAge=");
            stringBuilder.append(LocationRequest.zzf(this.zzi));
        }
        if (this.zze != Long.MAX_VALUE) {
            stringBuilder.append(", duration=");
            zzdj.zzb(this.zze, stringBuilder);
        }
        if (this.zzf != Integer.MAX_VALUE) {
            stringBuilder.append(", maxUpdates=");
            stringBuilder.append(this.zzf);
        }
        if (this.zzk != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(zzai.zza(this.zzk));
        }
        if (this.zzj != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(com.google.android.gms.location.zzo.zzb(this.zzj));
        }
        if (this.zzh) {
            stringBuilder.append(", waitForAccurateLocation");
        }
        if (this.zzm) {
            stringBuilder.append(", bypass");
        }
        if (this.zzl != null) {
            stringBuilder.append(", moduleId=");
            stringBuilder.append(this.zzl);
        }
        if (!WorkSourceUtil.isEmpty((WorkSource)this.zzn)) {
            stringBuilder.append(", ");
            stringBuilder.append(this.zzn);
        }
        if (this.zzo != null) {
            stringBuilder.append(", impersonation=");
            stringBuilder.append((Object)this.zzo);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        zzx zzx2;
        CREATOR = zzx2 = new zzx();
    }

    @Deprecated
    public LocationRequest() {
        WorkSource workSource = new WorkSource();
        this(102, 3600000L, 600000L, 0L, Long.MAX_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE, 0.0f, true, 3600000L, 0, 0, null, false, workSource, null);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getPriority());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.getIntervalMillis());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.getMinUpdateIntervalMillis());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)6, (int)this.getMaxUpdates());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)7, (float)this.getMinUpdateDistanceMeters());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)8, (long)this.getMaxUpdateDelayMillis());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)9, (boolean)this.isWaitForAccurateLocation());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)10, (long)this.getDurationMillis());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)11, (long)this.getMaxUpdateAgeMillis());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)12, (int)this.getGranularity());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)13, (int)this.zzk);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)14, (String)this.zzl, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)15, (boolean)this.zzm);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)16, (Parcelable)this.zzn, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)17, (Parcelable)this.zzo, (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof LocationRequest) {
            LocationRequest locationRequest;
            locationRequest = locationRequest;
            return !(this.zza != locationRequest.zza || !this.isPassive() && this.zzb != locationRequest.zzb || this.zzc != locationRequest.zzc || this.isBatched() != locationRequest.isBatched() || this.isBatched() && this.zzd != locationRequest.zzd || this.zze != locationRequest.zze || this.zzf != locationRequest.zzf || this.zzg != locationRequest.zzg || this.zzh != locationRequest.zzh || this.zzj != locationRequest.zzj || this.zzk != locationRequest.zzk || this.zzm != locationRequest.zzm || !this.zzn.equals((Object)locationRequest.zzn) || !Objects.equal((Object)this.zzl, (Object)locationRequest.zzl) || !Objects.equal((Object)((Object)this.zzo), (Object)((Object)locationRequest.zzo)));
        }
        return false;
    }

    @Pure
    public boolean isBatched() {
        long l = this.zzd;
        return l > 0L && l >> 1 >= this.zzb;
    }

    @Deprecated
    @Pure
    public boolean isFastestIntervalExplicitlySet() {
        return true;
    }

    @Pure
    public boolean isPassive() {
        return this.zza == 105;
    }

    public boolean isWaitForAccurateLocation() {
        return this.zzh;
    }

    @Pure
    public final int zza() {
        return this.zzk;
    }

    @Pure
    @NonNull
    public final WorkSource zzb() {
        return this.zzn;
    }

    @Pure
    @Nullable
    public final zzd zzc() {
        return this.zzo;
    }

    private static String zzf(long l) {
        if (l == Long.MAX_VALUE) {
            return "\u221e";
        }
        return zzdj.zza(l);
    }

    @Deprecated
    @Pure
    @Nullable
    public final String zzd() {
        return this.zzl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    LocationRequest(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) long l2, @SafeParcelable.Param(id=8) long l3, @SafeParcelable.RemovedParam(id=5, defaultValueUnchecked="Long.MAX_VALUE") long l4, @SafeParcelable.Param(id=10) long l5, @SafeParcelable.Param(id=6) int n2, @SafeParcelable.Param(id=7) float f, @SafeParcelable.Param(id=9) boolean bl, @SafeParcelable.Param(id=11) long l6, @SafeParcelable.Param(id=12) int n3, @SafeParcelable.Param(id=13) int n4, @SafeParcelable.Param(id=14) @Nullable String string, @SafeParcelable.Param(id=15) boolean bl2, @SafeParcelable.Param(id=16) WorkSource workSource, @SafeParcelable.Param(id=17) @Nullable zzd zzd2) {
        this.zza = n;
        this.zzb = l;
        this.zzc = l2;
        this.zzd = l3;
        l2 = l4 == Long.MAX_VALUE ? l5 : Math.min(Math.max(1L, l4 - SystemClock.elapsedRealtime()), l5);
        this.zze = l2;
        this.zzf = n2;
        this.zzg = f;
        this.zzh = bl;
        if (l6 != -1L) {
            l = l6;
        }
        this.zzi = l;
        this.zzj = n3;
        this.zzk = n4;
        this.zzl = string;
        this.zzm = bl2;
        this.zzn = workSource;
        this.zzo = zzd2;
    }

    @Pure
    public final boolean zze() {
        return this.zzm;
    }

    public static final class Builder {
        public static final long IMPLICIT_MIN_UPDATE_INTERVAL = -1L;
        public static final long IMPLICIT_MAX_UPDATE_AGE = -1L;
        private int zza;
        private long zzb;
        private long zzc;
        private long zzd;
        private long zze;
        private int zzf;
        private float zzg;
        private boolean zzh;
        private long zzi;
        private int zzj;
        private int zzk;
        @Nullable
        private String zzl;
        private boolean zzm;
        @Nullable
        private WorkSource zzn;
        @Nullable
        private zzd zzo;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setDurationMillis(long durationMillis) {
            void var1_1;
            boolean bl = durationMillis > 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"durationMillis must be greater than 0");
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGranularity(int granularity) {
            void var1_1;
            com.google.android.gms.location.zzo.zza(granularity);
            this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setIntervalMillis(long intervalMillis) {
            void var1_1;
            boolean bl = intervalMillis >= 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"intervalMillis must be greater than or equal to 0");
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdateAgeMillis(long maxUpdateAgeMillis) {
            void var1_1;
            boolean bl = maxUpdateAgeMillis != -1L ? var1_1 >= 0L : true;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdateAgeMillis must be greater than or equal to 0, or IMPLICIT_MAX_UPDATE_AGE");
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdateDelayMillis(long maxUpdateDelayMillis) {
            void var1_1;
            boolean bl = maxUpdateDelayMillis >= 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdateDelayMillis must be greater than or equal to 0");
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdates(int maxUpdates) {
            void var1_1;
            boolean bl = maxUpdates > 0;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdates must be greater than 0");
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMinUpdateDistanceMeters(float minUpdateDistanceMeters) {
            void var1_1;
            boolean bl = minUpdateDistanceMeters >= 0.0f;
            Preconditions.checkArgument((boolean)bl, (Object)"minUpdateDistanceMeters must be greater than or equal to 0");
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMinUpdateIntervalMillis(long minUpdateIntervalMillis) {
            void var1_1;
            boolean bl = minUpdateIntervalMillis != -1L ? var1_1 >= 0L : true;
            Preconditions.checkArgument((boolean)bl, (Object)"minUpdateIntervalMillis must be greater than or equal to 0, or IMPLICIT_MIN_UPDATE_INTERVAL");
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPriority(int priority) {
            void var1_1;
            zzae.zza(priority);
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setWaitForAccurateLocation(boolean waitForAccurateLocation) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public LocationRequest build() {
            int n = this.zza;
            long l = this.zzb;
            long l2 = this.zzc;
            long l3 = l2 == -1L ? l : (n == 105 ? l2 : Math.min(l2, l));
            long l4 = Math.max(this.zzd, this.zzb);
            long l5 = this.zze;
            int n2 = this.zzf;
            float f = this.zzg;
            boolean bl = this.zzh;
            long l6 = this.zzi;
            long l7 = l6 == -1L ? this.zzb : l6;
            int n3 = this.zzj;
            int n4 = this.zzk;
            String string = this.zzl;
            boolean bl2 = this.zzm;
            WorkSource workSource = new WorkSource(this.zzn);
            return new LocationRequest(n, l, l3, l4, Long.MAX_VALUE, l5, n2, f, bl, l7, n3, n4, string, bl2, workSource, this.zzo);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public Builder(long intervalMillis) {
            void var1_1;
            boolean bl = var1_1 >= 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"intervalMillis must be greater than or equal to 0");
            this.zzb = var1_1;
            this.zza = 102;
            this.zzc = -1L;
            this.zzd = 0L;
            this.zze = Long.MAX_VALUE;
            this.zzf = Integer.MAX_VALUE;
            this.zzg = 0.0f;
            this.zzh = true;
            this.zzi = -1L;
            this.zzj = 0;
            this.zzk = 0;
            this.zzl = null;
            this.zzm = false;
            this.zzn = null;
            this.zzo = null;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull LocationRequest request) {
            void var1_1;
            this.zza = var1_1.getPriority();
            this.zzb = var1_1.getIntervalMillis();
            this.zzc = var1_1.getMinUpdateIntervalMillis();
            this.zzd = var1_1.getMaxUpdateDelayMillis();
            this.zze = var1_1.getDurationMillis();
            this.zzf = var1_1.getMaxUpdates();
            this.zzg = var1_1.getMinUpdateDistanceMeters();
            this.zzh = var1_1.isWaitForAccurateLocation();
            this.zzi = var1_1.getMaxUpdateAgeMillis();
            this.zzj = var1_1.getGranularity();
            this.zzk = var1_1.zza();
            this.zzl = var1_1.zzd();
            this.zzm = var1_1.zze();
            this.zzn = var1_1.zzb();
            this.zzo = var1_1.zzc();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public Builder(int priority, long intervalMillis) {
            void var1_1;
            void var2_2;
            boolean bl = var2_2 >= 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"intervalMillis must be greater than or equal to 0");
            zzae.zza((int)var1_1);
            this.zza = var1_1;
            this.zzb = var2_2;
            this.zzc = -1L;
            this.zzd = 0L;
            this.zze = Long.MAX_VALUE;
            this.zzf = Integer.MAX_VALUE;
            this.zzg = 0.0f;
            this.zzh = true;
            this.zzi = -1L;
            this.zzj = 0;
            this.zzk = 0;
            this.zzl = null;
            this.zzm = false;
            this.zzn = null;
            this.zzo = null;
        }

        @RequiresPermission(anyOf={"android.permission.WRITE_SECURE_SETTINGS", "android.permission.LOCATION_BYPASS"})
        @NonNull
        public final Builder zza(boolean bl) {
            this.zzm = bl;
            return this;
        }

        @Deprecated
        @NonNull
        public final Builder zzb(@Nullable String string) {
            if (Build.VERSION.SDK_INT < 30) {
                this.zzl = string;
            }
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public final Builder zzc(int n) {
            boolean bl;
            int n2;
            int n3;
            block4: {
                block5: {
                    if (n == 0) break block5;
                    if (n != 1) {
                        if (n == 2) {
                            n3 = 2;
                            n2 = 2;
                            bl = true;
                            break block4;
                        } else {
                            n3 = n;
                            n2 = n;
                            bl = false;
                        }
                        break block4;
                    } else {
                        n3 = n;
                        n2 = n;
                        bl = true;
                    }
                    break block4;
                }
                n3 = n;
                n2 = n;
                bl = true;
            }
            Object[] objectArray = new Object[]{n2};
            Preconditions.checkArgument((boolean)bl, (String)"throttle behavior %d must be a ThrottleBehavior.THROTTLE_* constant", (Object[])objectArray);
            this.zzk = n3;
            return this;
        }

        @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
        @NonNull
        public final Builder zzd(@Nullable WorkSource workSource) {
            this.zzn = workSource;
            return this;
        }
    }
}

