/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.zzag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="SleepSegmentEventCreator")
public class SleepSegmentEvent
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<SleepSegmentEvent> CREATOR;
    public static final int STATUS_SUCCESSFUL = 0;
    public static final int STATUS_MISSING_DATA = 1;
    public static final int STATUS_NOT_DETECTED = 2;
    @SafeParcelable.Field(id=1, getter="getStartTimeMillis")
    private final long zza;
    @SafeParcelable.Field(id=2, getter="getEndTimeMillis")
    private final long zzb;
    @SafeParcelable.Field(id=3, getter="getStatus")
    private final int zzc;
    @SafeParcelable.Field(id=4, getter="getMissingDataDurationMinutes")
    private final int zzd;
    @SafeParcelable.Field(id=5, getter="getNinetiethPctConfidence")
    private final int zze;

    public int getStatus() {
        return this.zzc;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getEndTimeMillis() {
        return this.zzb;
    }

    public long getSegmentDurationMillis() {
        return this.zzb - this.zza;
    }

    public long getStartTimeMillis() {
        return this.zza;
    }

    @NonNull
    public String toString() {
        long l = this.zza;
        long l2 = this.zzb;
        int n = this.zzc;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("startMillis=");
        stringBuilder.append(l);
        stringBuilder.append(", endMillis=");
        stringBuilder.append(l2);
        stringBuilder.append(", status=");
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    @NonNull
    public static List<SleepSegmentEvent> extractEvents(@NonNull Intent intent) {
        Intent intent2;
        Preconditions.checkNotNull((Object)intent);
        if (!SleepSegmentEvent.hasEvents(intent2)) {
            return Collections.emptyList();
        }
        ArrayList arrayList = (ArrayList)intent2.getSerializableExtra("com.google.android.location.internal.EXTRA_SLEEP_SEGMENT_RESULT");
        if (arrayList == null) {
            return Collections.emptyList();
        }
        ArrayList<SleepSegmentEvent> arrayList2 = new ArrayList<SleepSegmentEvent>(arrayList.size());
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = (byte[])arrayList.get(i);
            Preconditions.checkNotNull((Object)byArray);
            arrayList2.add((SleepSegmentEvent)SafeParcelableSerializer.deserializeFromBytes((byte[])byArray, CREATOR));
        }
        return Collections.unmodifiableList(arrayList2);
    }

    static {
        zzag zzag2;
        CREATOR = zzag2 = new zzag();
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    @ShowFirstParty
    public SleepSegmentEvent(@SafeParcelable.Param(id=1) long l, @SafeParcelable.Param(id=2) long l2, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) int n3) {
        boolean bl = l <= l2;
        Preconditions.checkArgument((boolean)bl, (Object)"endTimeMillis must be greater than or equal to startTimeMillis");
        this.zza = l;
        this.zzb = l2;
        this.zzc = n;
        this.zzd = n2;
        this.zze = n3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        Preconditions.checkNotNull((Object)out);
        n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)1, (long)this.getStartTimeMillis());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.getEndTimeMillis());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getStatus());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.zzd);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)5, (int)this.zze);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof SleepSegmentEvent) {
            SleepSegmentEvent sleepSegmentEvent;
            return this.zza == (sleepSegmentEvent = (SleepSegmentEvent)sleepSegmentEvent).getStartTimeMillis() && this.zzb == sleepSegmentEvent.getEndTimeMillis() && this.zzc == sleepSegmentEvent.getStatus() && this.zzd == sleepSegmentEvent.zzd && this.zze == sleepSegmentEvent.zze;
        }
        return false;
    }

    public static boolean hasEvents(@Nullable Intent intent) {
        Intent intent2;
        if (intent == null) {
            return false;
        }
        return intent2.hasExtra("com.google.android.location.internal.EXTRA_SLEEP_SEGMENT_RESULT");
    }
}

