/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.zzm;
import java.util.Locale;

public class ParcelableGeofence
implements SafeParcelable,
Geofence {
    private final int zzzH;
    private final String zzAu;
    private final long zzars;
    private final short zzapK;
    private final double zzapL;
    private final double zzapM;
    private final float zzapN;
    private final int zzapI;
    private final int zzapO;
    private final int zzapP;
    public static final zzm CREATOR = new zzm();

    public ParcelableGeofence(int version, String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        ParcelableGeofence.zzcH(requestId);
        ParcelableGeofence.zze(radius);
        ParcelableGeofence.zza(latitude, longitude);
        transitionTypes = ParcelableGeofence.zzfK(transitionTypes);
        this.zzzH = version;
        this.zzapK = type;
        this.zzAu = requestId;
        this.zzapL = latitude;
        this.zzapM = longitude;
        this.zzapN = radius;
        this.zzars = expireAt;
        this.zzapI = transitionTypes;
        this.zzapO = notificationResponsiveness;
        this.zzapP = loiteringDelayMillis;
    }

    public ParcelableGeofence(String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        this(1, requestId, transitionTypes, type, latitude, longitude, radius, expireAt, notificationResponsiveness, loiteringDelayMillis);
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    public short zzsM() {
        return this.zzapK;
    }

    public double getLatitude() {
        return this.zzapL;
    }

    public double getLongitude() {
        return this.zzapM;
    }

    public float zzsN() {
        return this.zzapN;
    }

    @Override
    public String getRequestId() {
        return this.zzAu;
    }

    public long getExpirationTime() {
        return this.zzars;
    }

    public int zzsO() {
        return this.zzapI;
    }

    public int getNotificationResponsiveness() {
        return this.zzapO;
    }

    public int zzsP() {
        return this.zzapP;
    }

    private static void zzcH(String string) {
        if (string == null || string.length() > 100) {
            throw new IllegalArgumentException("requestId is null or too long: " + string);
        }
    }

    private static void zze(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("invalid radius: " + f);
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException("invalid latitude: " + d);
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException("invalid longitude: " + d2);
        }
    }

    private static int zzfK(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException("No supported transition specified: " + n);
        }
        return n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzm.zza(this, parcel, flags);
    }

    private static String zzfL(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static ParcelableGeofence zzk(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        ParcelableGeofence parcelableGeofence = CREATOR.zzdJ(parcel);
        parcel.recycle();
        return parcelableGeofence;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", ParcelableGeofence.zzfL(this.zzapK), this.zzAu, this.zzapI, this.zzapL, this.zzapM, Float.valueOf(this.zzapN), this.zzapO / 1000, this.zzapP, this.zzars);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.zzapL);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzapM);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        n2 = 31 * n2 + Float.floatToIntBits(this.zzapN);
        n2 = 31 * n2 + this.zzapK;
        n2 = 31 * n2 + this.zzapI;
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParcelableGeofence)) {
            return false;
        }
        ParcelableGeofence parcelableGeofence = (ParcelableGeofence)obj;
        if (this.zzapN != parcelableGeofence.zzapN) {
            return false;
        }
        if (this.zzapL != parcelableGeofence.zzapL) {
            return false;
        }
        if (this.zzapM != parcelableGeofence.zzapM) {
            return false;
        }
        return this.zzapK == parcelableGeofence.zzapK;
    }
}

