/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationStatusCodes;
import com.google.android.gms.location.copresence.internal.CopresenceApiOptions;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.zzf;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzh;
import com.google.android.gms.location.internal.zzi;
import java.util.List;

public class zzj
extends com.google.android.gms.location.internal.zzb {
    private final zzi zzaCQ;
    private final com.google.android.gms.location.copresence.internal.zzb zzaCR;

    public zzj(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, com.google.android.gms.common.internal.zzf.zzaj((Context)context));
    }

    public zzj(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, com.google.android.gms.common.internal.zzf zzf2) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzf2, CopresenceApiOptions.zzaCp);
    }

    public zzj(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, com.google.android.gms.common.internal.zzf zzf2, CopresenceApiOptions copresenceApiOptions) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzf2);
        this.zzaCQ = new zzi(context, this.zzaCs);
        this.zzaCR = com.google.android.gms.location.copresence.internal.zzb.zza(context, zzf2.getAccountName(), zzf2.zzol(), this.zzaCs, copresenceApiOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzi zzi2 = this.zzaCQ;
        synchronized (zzi2) {
            if (this.isConnected()) {
                try {
                    this.zzaCQ.removeAllListeners();
                    this.zzaCQ.zzvR();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
        }
    }

    public boolean zzoC() {
        return true;
    }

    public void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.zzoz();
        zzx.zzv((Object)pendingIntent);
        zzx.zzb((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzg)this.zzoA()).zza(l, true, pendingIntent);
    }

    public void zza(PendingIntent pendingIntent) throws RemoteException {
        this.zzoz();
        zzx.zzv((Object)pendingIntent);
        ((zzg)this.zzoA()).zza(pendingIntent);
    }

    public void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zzc.zzb<Status> zzb2) throws RemoteException {
        this.zzoz();
        zzx.zzb((Object)geofencingRequest, (Object)"geofencingRequest can't be null.");
        zzx.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        zza zza2 = new zza(zzb2);
        ((zzg)this.zzoA()).zza(geofencingRequest, pendingIntent, zza2);
    }

    public void zza(PendingIntent pendingIntent, zzc.zzb<Status> zzb2) throws RemoteException {
        this.zzoz();
        zzx.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        zzb zzb3 = new zzb(zzb2);
        ((zzg)this.zzoA()).zza(pendingIntent, (zzf)zzb3, this.getContext().getPackageName());
    }

    public void zza(List<String> list, zzc.zzb<Status> zzb2) throws RemoteException {
        this.zzoz();
        zzx.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"geofenceRequestIds can't be null nor empty.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        String[] stringArray = list.toArray(new String[0]);
        zzb zzb3 = new zzb(zzb2);
        ((zzg)this.zzoA()).zza(stringArray, (zzf)zzb3, this.getContext().getPackageName());
    }

    public Location getLastLocation() {
        return this.zzaCQ.getLastLocation();
    }

    public LocationAvailability zzvQ() {
        return this.zzaCQ.zzvQ();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper) throws RemoteException {
        zzi zzi2 = this.zzaCQ;
        synchronized (zzi2) {
            this.zzaCQ.zza(locationRequestInternal, locationCallback, looper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper) throws RemoteException {
        zzi zzi2 = this.zzaCQ;
        synchronized (zzi2) {
            this.zzaCQ.zza(locationRequest, locationListener, looper);
        }
    }

    public void zzb(LocationRequest locationRequest, PendingIntent pendingIntent) throws RemoteException {
        this.zzaCQ.zzb(locationRequest, pendingIntent);
    }

    public void zza(LocationListener locationListener) throws RemoteException {
        this.zzaCQ.zza(locationListener);
    }

    public void zzf(PendingIntent pendingIntent) throws RemoteException {
        this.zzaCQ.zzf(pendingIntent);
    }

    public void zza(LocationCallback locationCallback) throws RemoteException {
        this.zzaCQ.zza(locationCallback);
    }

    public void zzag(boolean bl) throws RemoteException {
        this.zzaCQ.zzag(bl);
    }

    public void zzb(Location location) throws RemoteException {
        this.zzaCQ.zzb(location);
    }

    public void zza(LocationSettingsRequest locationSettingsRequest, zzc.zzb<LocationSettingsResult> zzb2, String string) throws RemoteException {
        this.zzoz();
        zzx.zzb((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        zzx.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzc zzc2 = new zzc(zzb2);
        ((zzg)this.zzoA()).zza(locationSettingsRequest, zzc2, string);
    }

    private static final class zzc
    extends zzh.zza {
        private zzc.zzb<LocationSettingsResult> zzaCS;

        public zzc(zzc.zzb<LocationSettingsResult> zzb2) {
            zzx.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
            this.zzaCS = zzb2;
        }

        @Override
        public void zza(LocationSettingsResult locationSettingsResult) throws RemoteException {
            this.zzaCS.zzn((Object)locationSettingsResult);
            this.zzaCS = null;
        }
    }

    private static final class zzb
    extends zzf.zza {
        private zzc.zzb<Status> zzaCS;

        public zzb(zzc.zzb<Status> zzb2) {
            this.zzaCS = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onAddGeofencesResult");
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            this.zzgQ(n);
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            this.zzgQ(n);
        }

        private void zzgQ(int n) {
            if (this.zzaCS == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzgN(LocationStatusCodes.zzgM(n));
            this.zzaCS.zzn((Object)status);
            this.zzaCS = null;
        }
    }

    private static final class zza
    extends zzf.zza {
        private zzc.zzb<Status> zzaCS;

        public zza(zzc.zzb<Status> zzb2) {
            this.zzaCS = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            if (this.zzaCS == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzgN(LocationStatusCodes.zzgM(n));
            this.zzaCS.zzn((Object)status);
            this.zzaCS = null;
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByRequestIdsResult");
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByPendingIntentResult");
        }
    }
}

