/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int mVersionCode;
    int mPriority;
    long zzaEE;
    long zzaEF;
    boolean zzasP;
    long zzaEj;
    int zzaEG;
    float zzaEH;
    long zzaEI;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mVersionCode = 1;
        this.mPriority = 102;
        this.zzaEE = 3600000L;
        this.zzaEF = 600000L;
        this.zzasP = false;
        this.zzaEj = Long.MAX_VALUE;
        this.zzaEG = Integer.MAX_VALUE;
        this.zzaEH = 0.0f;
        this.zzaEI = 0L;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.zzgP(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.zzK(millis);
        this.zzaEE = millis;
        if (!this.zzasP) {
            this.zzaEF = (long)((double)this.zzaEE / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzaEE;
    }

    public LocationRequest setMaxWaitTime(long millis) {
        LocationRequest.zzK(millis);
        this.zzaEI = millis;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzaEI;
        if (l < this.zzaEE) {
            l = this.zzaEE;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.zzK(millis);
        this.zzasP = true;
        this.zzaEF = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.zzaEF;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l = SystemClock.elapsedRealtime();
        this.zzaEj = millis > Long.MAX_VALUE - l ? Long.MAX_VALUE : millis + l;
        if (this.zzaEj < 0L) {
            this.zzaEj = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.zzaEj = millis;
        if (this.zzaEj < 0L) {
            this.zzaEj = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zzaEj;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.zzaEG = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.zzaEG;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.zzd(smallestDisplacementMeters);
        this.zzaEH = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.zzaEH;
    }

    private static void zzK(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l);
        }
    }

    private static void zzgP(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n);
            }
        }
    }

    private static void zzd(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement, long maxWaitTime) {
        this.mVersionCode = versionCode;
        this.mPriority = priority;
        this.zzaEE = interval;
        this.zzaEF = fastestInterval;
        this.zzasP = explicitFastestInterval;
        this.zzaEj = expireAt;
        this.zzaEG = numUpdates;
        this.zzaEH = smallestDisplacement;
        this.zzaEI = maxWaitTime;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.zza(this, parcel, flags);
    }

    public static String zzgQ(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzgQ(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzaEE).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzaEF).append("ms");
        if (this.zzaEI > this.zzaEE) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzaEI).append("ms");
        }
        if (this.zzaEj != Long.MAX_VALUE) {
            long l = this.zzaEj - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzaEG != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzaEG);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.mPriority, this.zzaEE, this.zzaEF, this.zzasP, this.zzaEj, this.zzaEG, Float.valueOf(this.zzaEH)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.zzaEE == locationRequest.zzaEE && this.zzaEF == locationRequest.zzaEF && this.zzasP == locationRequest.zzasP && this.zzaEj == locationRequest.zzaEj && this.zzaEG == locationRequest.zzaEG && this.zzaEH == locationRequest.zzaEH;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }
}

