/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.ParcelableGeofence;
import com.google.android.gms.location.zza;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
implements SafeParcelable {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zza();
    private final int mVersionCode;
    private final List<ParcelableGeofence> zzaKZ;
    private final int zzaLa;

    GeofencingRequest(int version, List<ParcelableGeofence> geofences, int initialTrigger) {
        this.mVersionCode = version;
        this.zzaKZ = geofences;
        this.zzaLa = initialTrigger;
    }

    private GeofencingRequest(List<ParcelableGeofence> geofences, int initialTrigger) {
        this(1, geofences, initialTrigger);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public List<ParcelableGeofence> zzxW() {
        return this.zzaKZ;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzaKZ);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzaLa;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zza.zza(this, dest, flags);
    }

    public static final class Builder {
        private final List<ParcelableGeofence> zzaKZ = new ArrayList<ParcelableGeofence>();
        private int zzaLa = 5;

        public Builder addGeofence(Geofence geofence) {
            zzx.zzb((Object)geofence, (Object)"geofence can't be null.");
            zzx.zzb((boolean)(geofence instanceof ParcelableGeofence), (Object)"Geofence must be created using Geofence.Builder.");
            this.zzaKZ.add((ParcelableGeofence)geofence);
            return this;
        }

        public Builder addGeofences(List<Geofence> geofences) {
            if (geofences == null || geofences.isEmpty()) {
                return this;
            }
            for (Geofence geofence : geofences) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public Builder setInitialTrigger(int initialTrigger) {
            this.zzaLa = Builder.zzhg(initialTrigger);
            return this;
        }

        public static int zzhg(int n) {
            return n & 7;
        }

        public GeofencingRequest build() {
            zzx.zzb((!this.zzaKZ.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzaKZ, this.zzaLa);
        }
    }
}

