/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class LocationSettingsRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<LocationRequest> zzayS;
    private final boolean zzaLr;
    private final boolean zzaLs;
    public static final Parcelable.Creator<LocationSettingsRequest> CREATOR = new zzf();

    LocationSettingsRequest(int version, List<LocationRequest> locationRequests, boolean alwaysShow, boolean needBle) {
        this.mVersionCode = version;
        this.zzayS = locationRequests;
        this.zzaLr = alwaysShow;
        this.zzaLs = needBle;
    }

    private LocationSettingsRequest(List<LocationRequest> locationRequests, boolean alwaysShow, boolean needBle) {
        this(3, locationRequests, alwaysShow, needBle);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    public List<LocationRequest> zzux() {
        return Collections.unmodifiableList(this.zzayS);
    }

    public boolean zzxY() {
        return this.zzaLr;
    }

    public boolean zzxZ() {
        return this.zzaLs;
    }

    public static final class Builder {
        private final ArrayList<LocationRequest> zzaLt = new ArrayList();
        private boolean zzaLr = false;
        private boolean zzaLs = false;

        public Builder addLocationRequest(LocationRequest request) {
            this.zzaLt.add(request);
            return this;
        }

        public Builder addAllLocationRequests(Collection<LocationRequest> requests) {
            this.zzaLt.addAll(requests);
            return this;
        }

        public Builder setAlwaysShow(boolean show) {
            this.zzaLr = show;
            return this;
        }

        public Builder setNeedBle(boolean needBle) {
            this.zzaLs = needBle;
            return this;
        }

        public LocationSettingsRequest build() {
            return new LocationSettingsRequest(this.zzaLt, this.zzaLr, this.zzaLs);
        }
    }
}

