/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.zzo;
import java.util.Locale;

public class ParcelableGeofence
implements SafeParcelable,
Geofence {
    private final int mVersionCode;
    private final String zzDX;
    private final long zzaMl;
    private final short zzaKQ;
    private final double zzaKR;
    private final double zzaKS;
    private final float zzaKT;
    private final int zzaKO;
    private final int zzaKU;
    private final int zzaKV;
    public static final zzo CREATOR = new zzo();

    public ParcelableGeofence(int version, String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        ParcelableGeofence.zzdU(requestId);
        ParcelableGeofence.zze(radius);
        ParcelableGeofence.zza(latitude, longitude);
        transitionTypes = ParcelableGeofence.zzhw(transitionTypes);
        this.mVersionCode = version;
        this.zzaKQ = type;
        this.zzDX = requestId;
        this.zzaKR = latitude;
        this.zzaKS = longitude;
        this.zzaKT = radius;
        this.zzaMl = expireAt;
        this.zzaKO = transitionTypes;
        this.zzaKU = notificationResponsiveness;
        this.zzaKV = loiteringDelayMillis;
    }

    public ParcelableGeofence(String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        this(1, requestId, transitionTypes, type, latitude, longitude, radius, expireAt, notificationResponsiveness, loiteringDelayMillis);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public short zzyh() {
        return this.zzaKQ;
    }

    public double getLatitude() {
        return this.zzaKR;
    }

    public double getLongitude() {
        return this.zzaKS;
    }

    public float zzyi() {
        return this.zzaKT;
    }

    @Override
    public String getRequestId() {
        return this.zzDX;
    }

    public long getExpirationTime() {
        return this.zzaMl;
    }

    public int zzyj() {
        return this.zzaKO;
    }

    public int getNotificationResponsiveness() {
        return this.zzaKU;
    }

    public int zzyk() {
        return this.zzaKV;
    }

    private static void zzdU(String string) {
        if (string == null || string.length() > 100) {
            throw new IllegalArgumentException("requestId is null or too long: " + string);
        }
    }

    private static void zze(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("invalid radius: " + f);
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException("invalid latitude: " + d);
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException("invalid longitude: " + d2);
        }
    }

    private static int zzhw(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException("No supported transition specified: " + n);
        }
        return n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzo.zza(this, parcel, flags);
    }

    private static String zzhx(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static ParcelableGeofence zzo(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        ParcelableGeofence parcelableGeofence = CREATOR.zzeQ(parcel);
        parcel.recycle();
        return parcelableGeofence;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", ParcelableGeofence.zzhx(this.zzaKQ), this.zzDX, this.zzaKO, this.zzaKR, this.zzaKS, Float.valueOf(this.zzaKT), this.zzaKU / 1000, this.zzaKV, this.zzaMl);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.zzaKR);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzaKS);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        n2 = 31 * n2 + Float.floatToIntBits(this.zzaKT);
        n2 = 31 * n2 + this.zzaKQ;
        n2 = 31 * n2 + this.zzaKO;
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParcelableGeofence)) {
            return false;
        }
        ParcelableGeofence parcelableGeofence = (ParcelableGeofence)obj;
        if (this.zzaKT != parcelableGeofence.zzaKT) {
            return false;
        }
        if (this.zzaKR != parcelableGeofence.zzaKR) {
            return false;
        }
        if (this.zzaKS != parcelableGeofence.zzaKS) {
            return false;
        }
        return this.zzaKQ == parcelableGeofence.zzaKQ;
    }
}

