/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.ParcelableGeofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int zzFt;
    private final int zzaKW;
    private final List<Geofence> zzaKX;
    private final Location zzaKY;

    private GeofencingEvent(int errorCode, int transitionType, List<Geofence> triggeringGeofences, Location triggeringLocaton) {
        this.zzFt = errorCode;
        this.zzaKW = transitionType;
        this.zzaKX = triggeringGeofences;
        this.zzaKY = triggeringLocaton;
    }

    public static GeofencingEvent fromIntent(Intent intent) {
        if (intent == null) {
            return null;
        }
        int n = intent.getIntExtra("gms_error_code", -1);
        int n2 = GeofencingEvent.zzy(intent);
        List<Geofence> list = GeofencingEvent.zzz(intent);
        Location location = (Location)intent.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        return new GeofencingEvent(n, n2, list, location);
    }

    private static int zzy(Intent intent) {
        int n = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n == -1) {
            return -1;
        }
        if (n == 1 || n == 2 || n == 4) {
            return n;
        }
        return -1;
    }

    private static List<Geofence> zzz(Intent intent) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList == null) {
            return null;
        }
        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(arrayList.size());
        for (byte[] byArray : arrayList) {
            arrayList2.add(ParcelableGeofence.zzo(byArray));
        }
        return arrayList2;
    }

    public boolean hasError() {
        return this.zzFt != -1;
    }

    public int getErrorCode() {
        return this.zzFt;
    }

    public int getGeofenceTransition() {
        return this.zzaKW;
    }

    public List<Geofence> getTriggeringGeofences() {
        return this.zzaKX;
    }

    public Location getTriggeringLocation() {
        return this.zzaKY;
    }
}

