/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.location.internal.ParcelableGeofence;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzEY = null;
        private int zzaNC = 0;
        private long zzaND = Long.MIN_VALUE;
        private short zzaNE = (short)-1;
        private double zzaNF;
        private double zzaNG;
        private float zzaNH;
        private int zzaNI = 0;
        private int zzaNJ = -1;

        public Builder setRequestId(String requestId) {
            this.zzEY = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.zzaNC = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.zzaND = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.zzaNE = 1;
            this.zzaNF = latitude;
            this.zzaNG = longitude;
            this.zzaNH = radius;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            this.zzaNI = notificationResponsivenessMs;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.zzaNJ = loiteringDelayMs;
            return this;
        }

        public Geofence build() {
            if (this.zzEY == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzaNC == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzaNC & 4) != 0 && this.zzaNJ < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzaND == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzaNE == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzaNI < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new ParcelableGeofence(this.zzEY, this.zzaNC, 1, this.zzaNF, this.zzaNG, this.zzaNH, this.zzaND, this.zzaNI, this.zzaNJ);
        }
    }
}

