/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zze;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class LocationResult
implements SafeParcelable {
    static final List<Location> zzaOd = Collections.emptyList();
    private final int mVersionCode;
    private final List<Location> zzaOe;
    public static final Parcelable.Creator<LocationResult> CREATOR = new zze();

    public static LocationResult create(List<Location> locations) {
        if (locations == null) {
            locations = zzaOd;
        }
        return new LocationResult(2, locations);
    }

    LocationResult(int versionCode, List<Location> locations) {
        this.mVersionCode = versionCode;
        this.zzaOe = locations;
    }

    @NonNull
    public Location getLastLocation() {
        int n = this.zzaOe.size();
        if (n == 0) {
            return null;
        }
        return this.zzaOe.get(n - 1);
    }

    @NonNull
    public List<Location> getLocations() {
        return this.zzaOe;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zze.zza(this, parcel, flags);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int hashCode() {
        int n = 17;
        for (Location location : this.zzaOe) {
            long l = location.getTime();
            int n2 = (int)(l ^ l >>> 32);
            n = 31 * n + n2;
        }
        return n;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LocationResult)) {
            return false;
        }
        LocationResult locationResult = (LocationResult)other;
        if (locationResult.zzaOe.size() != this.zzaOe.size()) {
            return false;
        }
        Iterator<Location> iterator = locationResult.zzaOe.iterator();
        Iterator<Location> iterator2 = this.zzaOe.iterator();
        while (iterator.hasNext()) {
            Location location = iterator2.next();
            Location location2 = iterator.next();
            if (location.getTime() == location2.getTime()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "LocationResult[locations: " + this.zzaOe + "]";
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }

    public static LocationResult extractResult(Intent intent) {
        if (!LocationResult.hasResult(intent)) {
            return null;
        }
        return (LocationResult)intent.getExtras().getParcelable("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }
}

