/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.annotation.SuppressLint;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.zzo;
import java.util.Locale;

public class ParcelableGeofence
implements SafeParcelable,
Geofence {
    private final int mVersionCode;
    private final String zzEY;
    private final long zzaOZ;
    private final short zzaNE;
    private final double zzaNF;
    private final double zzaNG;
    private final float zzaNH;
    private final int zzaNC;
    private final int zzaNI;
    private final int zzaNJ;
    public static final zzo CREATOR = new zzo();

    public ParcelableGeofence(int version, String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        ParcelableGeofence.zzek(requestId);
        ParcelableGeofence.zze(radius);
        ParcelableGeofence.zza(latitude, longitude);
        transitionTypes = ParcelableGeofence.zzhF(transitionTypes);
        this.mVersionCode = version;
        this.zzaNE = type;
        this.zzEY = requestId;
        this.zzaNF = latitude;
        this.zzaNG = longitude;
        this.zzaNH = radius;
        this.zzaOZ = expireAt;
        this.zzaNC = transitionTypes;
        this.zzaNI = notificationResponsiveness;
        this.zzaNJ = loiteringDelayMillis;
    }

    public ParcelableGeofence(String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        this(1, requestId, transitionTypes, type, latitude, longitude, radius, expireAt, notificationResponsiveness, loiteringDelayMillis);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public short zzyT() {
        return this.zzaNE;
    }

    public double getLatitude() {
        return this.zzaNF;
    }

    public double getLongitude() {
        return this.zzaNG;
    }

    public float zzyU() {
        return this.zzaNH;
    }

    @Override
    public String getRequestId() {
        return this.zzEY;
    }

    public long getExpirationTime() {
        return this.zzaOZ;
    }

    public int zzyV() {
        return this.zzaNC;
    }

    public int getNotificationResponsiveness() {
        return this.zzaNI;
    }

    public int zzyW() {
        return this.zzaNJ;
    }

    private static void zzek(String string) {
        if (string == null || string.length() > 100) {
            throw new IllegalArgumentException("requestId is null or too long: " + string);
        }
    }

    private static void zze(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("invalid radius: " + f);
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException("invalid latitude: " + d);
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException("invalid longitude: " + d2);
        }
    }

    private static int zzhF(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException("No supported transition specified: " + n);
        }
        return n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzo.zza(this, parcel, flags);
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String zzhG(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static ParcelableGeofence zzo(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        ParcelableGeofence parcelableGeofence = CREATOR.zzeZ(parcel);
        parcel.recycle();
        return parcelableGeofence;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", ParcelableGeofence.zzhG(this.zzaNE), this.zzEY, this.zzaNC, this.zzaNF, this.zzaNG, Float.valueOf(this.zzaNH), this.zzaNI / 1000, this.zzaNJ, this.zzaOZ);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.zzaNF);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzaNG);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        n2 = 31 * n2 + Float.floatToIntBits(this.zzaNH);
        n2 = 31 * n2 + this.zzaNE;
        n2 = 31 * n2 + this.zzaNC;
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParcelableGeofence)) {
            return false;
        }
        ParcelableGeofence parcelableGeofence = (ParcelableGeofence)obj;
        if (this.zzaNH != parcelableGeofence.zzaNH) {
            return false;
        }
        if (this.zzaNF != parcelableGeofence.zzaNF) {
            return false;
        }
        if (this.zzaNG != parcelableGeofence.zzaNG) {
            return false;
        }
        return this.zzaNE == parcelableGeofence.zzaNE;
    }
}

