/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.Context;
import android.location.Location;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.LocationRequestUpdateData;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.internal.zzp;
import com.google.android.gms.location.zzc;
import com.google.android.gms.location.zzd;
import java.util.HashMap;
import java.util.Map;

public class zzk {
    private final zzp<zzi> zzaOt;
    private final Context mContext;
    private ContentProviderClient zzaOG = null;
    private boolean zzaOH = false;
    private Map<LocationListener, zzc> zzaxd = new HashMap<LocationListener, zzc>();
    private Map<LocationCallback, zza> zzaOI = new HashMap<LocationCallback, zza>();

    public zzk(Context context, zzp<zzi> zzp2) {
        this.mContext = context;
        this.zzaOt = zzp2;
    }

    public Location getLastLocation() {
        this.zzaOt.zzqI();
        try {
            Location location = this.zzaOt.zzqJ().zzei(this.mContext.getPackageName());
            return location;
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public LocationAvailability zzyO() {
        this.zzaOt.zzqI();
        try {
            return this.zzaOt.zzqJ().zzej(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper, zzg zzg2) throws RemoteException {
        this.zzaOt.zzqI();
        zzc zzc2 = this.zza(locationListener, looper);
        this.zzaOt.zzqJ().zza(LocationRequestUpdateData.zza(LocationRequestInternal.zzb(locationRequest), zzc2, zzg2));
    }

    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper, zzg zzg2) throws RemoteException {
        this.zzaOt.zzqI();
        zza zza2 = this.zza(locationCallback, looper);
        this.zzaOt.zzqJ().zza(LocationRequestUpdateData.zza(locationRequestInternal, zza2, zzg2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zza(LocationListener locationListener, Looper looper) {
        Map<LocationListener, zzc> map = this.zzaxd;
        synchronized (map) {
            zzc zzc2 = this.zzaxd.get(locationListener);
            if (zzc2 == null) {
                zzc2 = new zzc(locationListener, looper);
            }
            this.zzaxd.put(locationListener, zzc2);
            return zzc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zza zza(LocationCallback locationCallback, Looper looper) {
        Map<LocationCallback, zza> map = this.zzaOI;
        synchronized (map) {
            zza zza2 = this.zzaOI.get(locationCallback);
            if (zza2 == null) {
                zza2 = new zza(locationCallback, looper);
            }
            this.zzaOI.put(locationCallback, zza2);
            return zza2;
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaOt.zzqI();
        this.zzaOt.zzqJ().zza(LocationRequestUpdateData.zza(LocationRequestInternal.zzb(locationRequest), pendingIntent, zzg2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationListener locationListener, zzg zzg2) throws RemoteException {
        this.zzaOt.zzqI();
        zzx.zzb((Object)locationListener, (Object)"Invalid null listener");
        Map<LocationListener, zzc> map = this.zzaxd;
        synchronized (map) {
            zzc zzc2 = this.zzaxd.remove(locationListener);
            if (this.zzaOG != null && this.zzaxd.isEmpty()) {
                this.zzaOG.release();
                this.zzaOG = null;
            }
            if (zzc2 != null) {
                zzc2.release();
                this.zzaOt.zzqJ().zza(LocationRequestUpdateData.zza(zzc2, zzg2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationCallback locationCallback, zzg zzg2) throws RemoteException {
        this.zzaOt.zzqI();
        zzx.zzb((Object)locationCallback, (Object)"Invalid null callback");
        Map<LocationCallback, zza> map = this.zzaOI;
        synchronized (map) {
            zza zza2 = this.zzaOI.remove(locationCallback);
            if (zza2 != null) {
                zza2.release();
                this.zzaOt.zzqJ().zza(LocationRequestUpdateData.zza(zza2, zzg2));
            }
        }
    }

    public void zza(PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaOt.zzqI();
        this.zzaOt.zzqJ().zza(LocationRequestUpdateData.zzb(pendingIntent, zzg2));
    }

    public void zzam(boolean bl) throws RemoteException {
        this.zzaOt.zzqI();
        this.zzaOt.zzqJ().zzam(bl);
        this.zzaOH = bl;
    }

    public void zzc(Location location) throws RemoteException {
        this.zzaOt.zzqI();
        this.zzaOt.zzqJ().zzc(location);
    }

    public void zza(zzg zzg2) throws RemoteException {
        this.zzaOt.zzqI();
        this.zzaOt.zzqJ().zza(zzg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            Map<Object, Binder> map = this.zzaxd;
            synchronized (map) {
                for (zzc binder : this.zzaxd.values()) {
                    if (binder == null) continue;
                    this.zzaOt.zzqJ().zza(LocationRequestUpdateData.zza(binder, null));
                }
                this.zzaxd.clear();
            }
            map = this.zzaOI;
            synchronized (map) {
                for (zza zza2 : this.zzaOI.values()) {
                    if (zza2 == null) continue;
                    this.zzaOt.zzqJ().zza(LocationRequestUpdateData.zza(zza2, null));
                }
                this.zzaOI.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zzyP() {
        if (this.zzaOH) {
            try {
                this.zzam(false);
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    private static class zzb
    extends Handler {
        private final LocationListener zzaOL;

        public zzb(LocationListener locationListener) {
            this.zzaOL = locationListener;
        }

        public zzb(LocationListener locationListener, Looper looper) {
            super(looper);
            this.zzaOL = locationListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.zzaOL.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    private static class zza
    extends zzc.zza {
        private Handler zzaOJ;

        zza(final LocationCallback locationCallback, Looper looper) {
            if (looper == null) {
                looper = Looper.myLooper();
                zzx.zza((looper != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzaOJ = new Handler(looper){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            locationCallback.onLocationResult((LocationResult)msg.obj);
                            break;
                        }
                        case 1: {
                            locationCallback.onLocationAvailability((LocationAvailability)msg.obj);
                        }
                    }
                }
            };
        }

        @Override
        public void onLocationResult(LocationResult locationResult) {
            this.zzb(0, locationResult);
        }

        @Override
        public void onLocationAvailability(LocationAvailability state) {
            this.zzb(1, state);
        }

        public void release() {
            this.zzaOJ = null;
        }

        private void zzb(int n, Object object) {
            if (this.zzaOJ == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a data in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = n;
            message.obj = object;
            this.zzaOJ.sendMessage(message);
        }
    }

    private static class zzc
    extends zzd.zza {
        private Handler zzaOJ;

        zzc(LocationListener locationListener, Looper looper) {
            if (looper == null) {
                zzx.zza((Looper.myLooper() != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzaOJ = looper == null ? new zzb(locationListener) : new zzb(locationListener, looper);
        }

        @Override
        public void onLocationChanged(Location location) {
            if (this.zzaOJ == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.zzaOJ.sendMessage(message);
        }

        public void release() {
            this.zzaOJ = null;
        }
    }
}

