/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.location.internal.ParcelableGeofence;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzII = null;
        private int zzaUS = 0;
        private long zzaUT = Long.MIN_VALUE;
        private short zzaUU = (short)-1;
        private double zzaUV;
        private double zzaUW;
        private float zzaUX;
        private int zzaUY = 0;
        private int zzaUZ = -1;

        public Builder setRequestId(String string) {
            this.zzII = string;
            return this;
        }

        public Builder setTransitionTypes(int n) {
            this.zzaUS = n;
            return this;
        }

        public Builder setExpirationDuration(long l) {
            this.zzaUT = l < 0L ? -1L : SystemClock.elapsedRealtime() + l;
            return this;
        }

        public Builder setCircularRegion(double d, double d2, float f) {
            this.zzaUU = 1;
            this.zzaUV = d;
            this.zzaUW = d2;
            this.zzaUX = f;
            return this;
        }

        public Builder setNotificationResponsiveness(int n) {
            this.zzaUY = n;
            return this;
        }

        public Builder setLoiteringDelay(int n) {
            this.zzaUZ = n;
            return this;
        }

        public Geofence build() {
            if (this.zzII == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzaUS == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzaUS & 4) != 0 && this.zzaUZ < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzaUT == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzaUU == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzaUY < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new ParcelableGeofence(this.zzII, this.zzaUS, 1, this.zzaUV, this.zzaUW, this.zzaUX, this.zzaUT, this.zzaUY, this.zzaUZ);
        }
    }
}

