/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationStatusCodes;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzh;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.internal.zzj;
import com.google.android.gms.location.internal.zzk;
import java.util.List;

public class zzl
extends com.google.android.gms.location.internal.zzb {
    private final zzk zzaWc;

    public zzl(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, com.google.android.gms.common.internal.zzg.zzau((Context)context));
    }

    public zzl(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, com.google.android.gms.common.internal.zzg zzg2) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzg2);
        this.zzaWc = new zzk(context, this.zzaVJ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzk zzk2 = this.zzaWc;
        synchronized (zzk2) {
            if (this.isConnected()) {
                try {
                    this.zzaWc.removeAllListeners();
                    this.zzaWc.zzCx();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
        }
    }

    public void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.zztl();
        zzaa.zzz((Object)pendingIntent);
        zzaa.zzb((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzi)this.zztm()).zza(l, true, pendingIntent);
    }

    public void zza(PendingIntent pendingIntent) throws RemoteException {
        this.zztl();
        zzaa.zzz((Object)pendingIntent);
        ((zzi)this.zztm()).zza(pendingIntent);
    }

    public void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zznt.zzb<Status> zzb2) throws RemoteException {
        this.zztl();
        zzaa.zzb((Object)((Object)geofencingRequest), (Object)"geofencingRequest can't be null.");
        zzaa.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzaa.zzb(zzb2, (Object)"ResultHolder not provided.");
        zza zza2 = new zza(zzb2);
        ((zzi)this.zztm()).zza(geofencingRequest, pendingIntent, zza2);
    }

    public void zza(PendingIntent pendingIntent, zznt.zzb<Status> zzb2) throws RemoteException {
        this.zztl();
        zzaa.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzaa.zzb(zzb2, (Object)"ResultHolder not provided.");
        zzb zzb3 = new zzb(zzb2);
        ((zzi)this.zztm()).zza(pendingIntent, (zzh)zzb3, this.getContext().getPackageName());
    }

    public void zza(List<String> list, zznt.zzb<Status> zzb2) throws RemoteException {
        this.zztl();
        zzaa.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"geofenceRequestIds can't be null nor empty.");
        zzaa.zzb(zzb2, (Object)"ResultHolder not provided.");
        String[] stringArray = list.toArray(new String[0]);
        zzb zzb3 = new zzb(zzb2);
        ((zzi)this.zztm()).zza(stringArray, (zzh)zzb3, this.getContext().getPackageName());
    }

    public Location getLastLocation() {
        return this.zzaWc.getLastLocation();
    }

    public LocationAvailability zzCw() {
        return this.zzaWc.zzCw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper, zzg zzg2) throws RemoteException {
        zzk zzk2 = this.zzaWc;
        synchronized (zzk2) {
            this.zzaWc.zza(locationRequestInternal, locationCallback, looper, zzg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper, zzg zzg2) throws RemoteException {
        zzk zzk2 = this.zzaWc;
        synchronized (zzk2) {
            this.zzaWc.zza(locationRequest, locationListener, looper, zzg2);
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaWc.zza(locationRequest, pendingIntent, zzg2);
    }

    public void zza(LocationListener locationListener, zzg zzg2) throws RemoteException {
        this.zzaWc.zza(locationListener, zzg2);
    }

    public void zza(PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaWc.zza(pendingIntent, zzg2);
    }

    public void zza(LocationCallback locationCallback, zzg zzg2) throws RemoteException {
        this.zzaWc.zza(locationCallback, zzg2);
    }

    public void zzat(boolean bl) throws RemoteException {
        this.zzaWc.zzat(bl);
    }

    public void zzc(Location location) throws RemoteException {
        this.zzaWc.zzc(location);
    }

    public void zza(zzg zzg2) throws RemoteException {
        this.zzaWc.zza(zzg2);
    }

    public void zza(LocationSettingsRequest locationSettingsRequest, zznt.zzb<LocationSettingsResult> zzb2, String string) throws RemoteException {
        this.zztl();
        zzaa.zzb((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        zzaa.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzc zzc2 = new zzc(zzb2);
        ((zzi)this.zztm()).zza(locationSettingsRequest, zzc2, string);
    }

    private static final class zzc
    extends zzj.zza {
        private zznt.zzb<LocationSettingsResult> zzaWd;

        public zzc(zznt.zzb<LocationSettingsResult> zzb2) {
            zzaa.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
            this.zzaWd = zzb2;
        }

        @Override
        public void zza(LocationSettingsResult locationSettingsResult) throws RemoteException {
            this.zzaWd.setResult((Object)locationSettingsResult);
            this.zzaWd = null;
        }
    }

    private static final class zzb
    extends zzh.zza {
        private zznt.zzb<Status> zzaWd;

        public zzb(zznt.zzb<Status> zzb2) {
            this.zzaWd = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onAddGeofencesResult");
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            this.zzif(n);
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            this.zzif(n);
        }

        private void zzif(int n) {
            if (this.zzaWd == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzic(LocationStatusCodes.zzib(n));
            this.zzaWd.setResult((Object)status);
            this.zzaWd = null;
        }
    }

    private static final class zza
    extends zzh.zza {
        private zznt.zzb<Status> zzaWd;

        public zza(zznt.zzb<Status> zzb2) {
            this.zzaWd = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            if (this.zzaWd == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzic(LocationStatusCodes.zzib(n));
            this.zzaWd.setResult((Object)status);
            this.zzaWd = null;
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByRequestIdsResult");
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByPendingIntentResult");
        }
    }
}

