/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
extends zza {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new zzk();
    private final List<LatLng> zzbpP;
    private final List<List<LatLng>> zzbpQ;
    private float mStrokeWidth = 10.0f;
    private int mStrokeColor = -16777216;
    private int mFillColor = 0;
    private float zzbpm = 0.0f;
    private boolean zzbpn = true;
    private boolean zzbpR = false;
    private boolean zzbpo = false;
    private int zzbpS = 0;
    @Nullable
    private List<PatternItem> zzbpp = null;

    public PolygonOptions() {
        this.zzbpP = new ArrayList<LatLng>();
        this.zzbpQ = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(List<LatLng> list, List list2, float f, int n, int n2, float f2, boolean bl, boolean bl2, boolean bl3, int n3, @Nullable List<PatternItem> list3) {
        this.zzbpP = list;
        this.zzbpQ = list2;
        this.mStrokeWidth = f;
        this.mStrokeColor = n;
        this.mFillColor = n2;
        this.zzbpm = f2;
        this.zzbpn = bl;
        this.zzbpR = bl2;
        this.zzbpo = bl3;
        this.zzbpS = n3;
        this.zzbpp = list3;
    }

    List zzJO() {
        return this.zzbpQ;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzk.zza(this, parcel, n);
    }

    public PolygonOptions add(LatLng latLng) {
        this.zzbpP.add(latLng);
        return this;
    }

    public PolygonOptions add(LatLng ... latLngArray) {
        this.zzbpP.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzbpP.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.zzbpQ.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float f) {
        this.mStrokeWidth = f;
        return this;
    }

    public PolygonOptions strokeColor(int n) {
        this.mStrokeColor = n;
        return this;
    }

    public PolygonOptions strokeJointType(int n) {
        this.zzbpS = n;
        return this;
    }

    public PolygonOptions strokePattern(@Nullable List<PatternItem> list) {
        this.zzbpp = list;
        return this;
    }

    public PolygonOptions fillColor(int n) {
        this.mFillColor = n;
        return this;
    }

    public PolygonOptions zIndex(float f) {
        this.zzbpm = f;
        return this;
    }

    public PolygonOptions visible(boolean bl) {
        this.zzbpn = bl;
        return this;
    }

    public PolygonOptions geodesic(boolean bl) {
        this.zzbpR = bl;
        return this;
    }

    public PolygonOptions clickable(boolean bl) {
        this.zzbpo = bl;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.zzbpP;
    }

    public List<List<LatLng>> getHoles() {
        return this.zzbpQ;
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    public int getStrokeJointType() {
        return this.zzbpS;
    }

    @Nullable
    public List<PatternItem> getStrokePattern() {
        return this.zzbpp;
    }

    public int getFillColor() {
        return this.mFillColor;
    }

    public float getZIndex() {
        return this.zzbpm;
    }

    public boolean isVisible() {
        return this.zzbpn;
    }

    public boolean isGeodesic() {
        return this.zzbpR;
    }

    public boolean isClickable() {
        return this.zzbpo;
    }
}

