/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.internal.zzc;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class zzai {
    private static Context zzboX;
    private static zzc zzboY;

    public static zzc zzbI(Context context) throws GooglePlayServicesNotAvailableException {
        zzac.zzw((Object)context);
        if (zzboY != null) {
            return zzboY;
        }
        zzai.zzbJ(context);
        zzboY = zzai.zzbK(context);
        try {
            zzboY.zzi(zzd.zzA((Object)zzai.getRemoteContext(context).getResources()), GooglePlayServicesUtil.GOOGLE_PLAY_SERVICES_VERSION_CODE);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return zzboY;
    }

    private static void zzbJ(Context context) throws GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        switch (n) {
            case 0: {
                return;
            }
        }
        throw new GooglePlayServicesNotAvailableException(n);
    }

    private static zzc zzbK(Context context) {
        Log.i((String)zzai.class.getSimpleName(), (String)"Making Creator dynamically");
        IBinder iBinder = (IBinder)zzai.zza(zzai.getRemoteContext(context).getClassLoader(), "com.google.android.gms.maps.internal.CreatorImpl");
        return zzc.zza.zzdt(iBinder);
    }

    private static Context getRemoteContext(Context context) {
        if (zzboX == null) {
            zzboX = GooglePlayServicesUtil.getRemoteContext((Context)context);
        }
        return zzboX;
    }

    private static <T> T zza(ClassLoader classLoader, String string) {
        try {
            return zzai.zze(((ClassLoader)zzac.zzw((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = String.valueOf(string);
            throw new IllegalStateException(string2.length() != 0 ? "Unable to find dynamic class ".concat(string2) : new String("Unable to find dynamic class "));
        }
    }

    private static <T> T zze(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to instantiate the dynamic class ".concat(string) : new String("Unable to instantiate the dynamic class "));
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to call the default constructor of ".concat(string) : new String("Unable to call the default constructor of "));
        }
    }
}

