/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
extends zza {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new zzk();
    private final List<LatLng> zzbpL;
    private final List<List<LatLng>> zzbpM;
    private float mStrokeWidth = 10.0f;
    private int mStrokeColor = -16777216;
    private int mFillColor = 0;
    private float zzbpi = 0.0f;
    private boolean zzbpj = true;
    private boolean zzbpN = false;
    private boolean zzbpk = false;
    private int zzbpO = 0;
    @Nullable
    private List<PatternItem> zzbpl = null;

    public PolygonOptions() {
        this.zzbpL = new ArrayList<LatLng>();
        this.zzbpM = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(List<LatLng> list, List list2, float f, int n, int n2, float f2, boolean bl, boolean bl2, boolean bl3, int n3, @Nullable List<PatternItem> list3) {
        this.zzbpL = list;
        this.zzbpM = list2;
        this.mStrokeWidth = f;
        this.mStrokeColor = n;
        this.mFillColor = n2;
        this.zzbpi = f2;
        this.zzbpj = bl;
        this.zzbpN = bl2;
        this.zzbpk = bl3;
        this.zzbpO = n3;
        this.zzbpl = list3;
    }

    List zzJP() {
        return this.zzbpM;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzk.zza(this, parcel, n);
    }

    public PolygonOptions add(LatLng latLng) {
        this.zzbpL.add(latLng);
        return this;
    }

    public PolygonOptions add(LatLng ... latLngArray) {
        this.zzbpL.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzbpL.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.zzbpM.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float f) {
        this.mStrokeWidth = f;
        return this;
    }

    public PolygonOptions strokeColor(int n) {
        this.mStrokeColor = n;
        return this;
    }

    public PolygonOptions strokeJointType(int n) {
        this.zzbpO = n;
        return this;
    }

    public PolygonOptions strokePattern(@Nullable List<PatternItem> list) {
        this.zzbpl = list;
        return this;
    }

    public PolygonOptions fillColor(int n) {
        this.mFillColor = n;
        return this;
    }

    public PolygonOptions zIndex(float f) {
        this.zzbpi = f;
        return this;
    }

    public PolygonOptions visible(boolean bl) {
        this.zzbpj = bl;
        return this;
    }

    public PolygonOptions geodesic(boolean bl) {
        this.zzbpN = bl;
        return this;
    }

    public PolygonOptions clickable(boolean bl) {
        this.zzbpk = bl;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.zzbpL;
    }

    public List<List<LatLng>> getHoles() {
        return this.zzbpM;
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    public int getStrokeJointType() {
        return this.zzbpO;
    }

    @Nullable
    public List<PatternItem> getStrokePattern() {
        return this.zzbpl;
    }

    public int getFillColor() {
        return this.mFillColor;
    }

    public float getZIndex() {
        return this.zzbpi;
    }

    public boolean isVisible() {
        return this.zzbpj;
    }

    public boolean isGeodesic() {
        return this.zzbpN;
    }

    public boolean isClickable() {
        return this.zzbpk;
    }
}

