/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;

public interface ICameraUpdateFactoryDelegate
extends IInterface {
    public IObjectWrapper zoomIn() throws RemoteException;

    public IObjectWrapper zoomOut() throws RemoteException;

    public IObjectWrapper scrollBy(float var1, float var2) throws RemoteException;

    public IObjectWrapper zoomTo(float var1) throws RemoteException;

    public IObjectWrapper zoomBy(float var1) throws RemoteException;

    public IObjectWrapper zoomByWithFocus(float var1, int var2, int var3) throws RemoteException;

    public IObjectWrapper newCameraPosition(CameraPosition var1) throws RemoteException;

    public IObjectWrapper newLatLng(LatLng var1) throws RemoteException;

    public IObjectWrapper newLatLngZoom(LatLng var1, float var2) throws RemoteException;

    public IObjectWrapper newLatLngBounds(LatLngBounds var1, int var2) throws RemoteException;

    public IObjectWrapper newLatLngBoundsWithSize(LatLngBounds var1, int var2, int var3, int var4) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate$zza
    extends Binder
    implements ICameraUpdateFactoryDelegate {
        public static ICameraUpdateFactoryDelegate zzdr(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
            if (iInterface != null && iInterface instanceof ICameraUpdateFactoryDelegate) {
                return (ICameraUpdateFactoryDelegate)iInterface;
            }
            return new zza(iBinder);
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                case 1598968902: {
                    parcel2.writeString("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    return true;
                }
                case 1: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    IObjectWrapper iObjectWrapper = this.zoomIn();
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iObjectWrapper != null ? iObjectWrapper.asBinder() : null);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    IObjectWrapper iObjectWrapper = this.zoomOut();
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iObjectWrapper != null ? iObjectWrapper.asBinder() : null);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f = parcel.readFloat();
                    float f2 = parcel.readFloat();
                    IObjectWrapper iObjectWrapper = this.scrollBy(f, f2);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iObjectWrapper != null ? iObjectWrapper.asBinder() : null);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f = parcel.readFloat();
                    IObjectWrapper iObjectWrapper = this.zoomTo(f);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iObjectWrapper != null ? iObjectWrapper.asBinder() : null);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f = parcel.readFloat();
                    IObjectWrapper iObjectWrapper = this.zoomBy(f);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iObjectWrapper != null ? iObjectWrapper.asBinder() : null);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f = parcel.readFloat();
                    int n3 = parcel.readInt();
                    int n4 = parcel.readInt();
                    IObjectWrapper iObjectWrapper = this.zoomByWithFocus(f, n3, n4);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iObjectWrapper != null ? iObjectWrapper.asBinder() : null);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    CameraPosition cameraPosition = 0 != parcel.readInt() ? (CameraPosition)((Object)CameraPosition.CREATOR.createFromParcel(parcel)) : null;
                    IObjectWrapper iObjectWrapper = this.newCameraPosition(cameraPosition);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iObjectWrapper != null ? iObjectWrapper.asBinder() : null);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLng latLng = 0 != parcel.readInt() ? (LatLng)((Object)LatLng.CREATOR.createFromParcel(parcel)) : null;
                    IObjectWrapper iObjectWrapper = this.newLatLng(latLng);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iObjectWrapper != null ? iObjectWrapper.asBinder() : null);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLng latLng = 0 != parcel.readInt() ? (LatLng)((Object)LatLng.CREATOR.createFromParcel(parcel)) : null;
                    float f = parcel.readFloat();
                    IObjectWrapper iObjectWrapper = this.newLatLngZoom(latLng, f);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iObjectWrapper != null ? iObjectWrapper.asBinder() : null);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLngBounds latLngBounds = 0 != parcel.readInt() ? (LatLngBounds)((Object)LatLngBounds.CREATOR.createFromParcel(parcel)) : null;
                    int n5 = parcel.readInt();
                    IObjectWrapper iObjectWrapper = this.newLatLngBounds(latLngBounds, n5);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iObjectWrapper != null ? iObjectWrapper.asBinder() : null);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLngBounds latLngBounds = 0 != parcel.readInt() ? (LatLngBounds)((Object)LatLngBounds.CREATOR.createFromParcel(parcel)) : null;
                    int n6 = parcel.readInt();
                    int n7 = parcel.readInt();
                    int n8 = parcel.readInt();
                    IObjectWrapper iObjectWrapper = this.newLatLngBoundsWithSize(latLngBounds, n6, n7, n8);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iObjectWrapper != null ? iObjectWrapper.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(n, parcel, parcel2, n2);
        }

        private static class zza
        implements ICameraUpdateFactoryDelegate {
            private IBinder zzrk;

            zza(IBinder iBinder) {
                this.zzrk = iBinder;
            }

            public IBinder asBinder() {
                return this.zzrk;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IObjectWrapper zoomIn() throws RemoteException {
                IObjectWrapper iObjectWrapper;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    this.zzrk.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iObjectWrapper;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IObjectWrapper zoomOut() throws RemoteException {
                IObjectWrapper iObjectWrapper;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    this.zzrk.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iObjectWrapper;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IObjectWrapper scrollBy(float f, float f2) throws RemoteException {
                IObjectWrapper iObjectWrapper;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(f);
                    parcel.writeFloat(f2);
                    this.zzrk.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iObjectWrapper;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IObjectWrapper zoomTo(float f) throws RemoteException {
                IObjectWrapper iObjectWrapper;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(f);
                    this.zzrk.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iObjectWrapper;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IObjectWrapper zoomBy(float f) throws RemoteException {
                IObjectWrapper iObjectWrapper;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(f);
                    this.zzrk.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iObjectWrapper;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IObjectWrapper zoomByWithFocus(float f, int n, int n2) throws RemoteException {
                IObjectWrapper iObjectWrapper;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(f);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.zzrk.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iObjectWrapper;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IObjectWrapper newCameraPosition(CameraPosition cameraPosition) throws RemoteException {
                IObjectWrapper iObjectWrapper;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (cameraPosition != null) {
                        parcel.writeInt(1);
                        cameraPosition.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzrk.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iObjectWrapper;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IObjectWrapper newLatLng(LatLng latLng) throws RemoteException {
                IObjectWrapper iObjectWrapper;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLng != null) {
                        parcel.writeInt(1);
                        latLng.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzrk.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iObjectWrapper;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IObjectWrapper newLatLngZoom(LatLng latLng, float f) throws RemoteException {
                IObjectWrapper iObjectWrapper;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLng != null) {
                        parcel.writeInt(1);
                        latLng.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeFloat(f);
                    this.zzrk.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iObjectWrapper;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IObjectWrapper newLatLngBounds(LatLngBounds latLngBounds, int n) throws RemoteException {
                IObjectWrapper iObjectWrapper;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLngBounds != null) {
                        parcel.writeInt(1);
                        latLngBounds.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.zzrk.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iObjectWrapper;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IObjectWrapper newLatLngBoundsWithSize(LatLngBounds latLngBounds, int n, int n2, int n3) throws RemoteException {
                IObjectWrapper iObjectWrapper;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLngBounds != null) {
                        parcel.writeInt(1);
                        latLngBounds.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.zzrk.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iObjectWrapper;
            }
        }
    }
}

