/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zze;

public final class LatLngBounds
extends zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new zze();
    public final LatLng southwest;
    public final LatLng northeast;

    public LatLngBounds(LatLng latLng, LatLng latLng2) {
        zzac.zzb((Object)((Object)latLng), (Object)"null southwest");
        zzac.zzb((Object)((Object)latLng2), (Object)"null northeast");
        zzac.zzb((latLng2.latitude >= latLng.latitude ? 1 : 0) != 0, (String)"southern latitude exceeds northern latitude (%s > %s)", (Object[])new Object[]{latLng.latitude, latLng2.latitude});
        this.southwest = latLng;
        this.northeast = latLng2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng latLng) {
        LatLng latLng2 = latLng;
        return this.zzh(latLng2.latitude) && this.zzi(latLng2.longitude);
    }

    public LatLngBounds including(LatLng latLng) {
        LatLng latLng2 = latLng;
        double d = Math.min(this.southwest.latitude, latLng2.latitude);
        double d2 = Math.max(this.northeast.latitude, latLng2.latitude);
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = latLng2.longitude;
        if (!this.zzi(d5)) {
            if (LatLngBounds.zzb(d4, d5) < LatLngBounds.zzc(d3, d5)) {
                d4 = d5;
            } else {
                d3 = d5;
            }
        }
        return new LatLngBounds(new LatLng(d, d4), new LatLng(d2, d3));
    }

    public LatLng getCenter() {
        double d = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d2 = this.southwest.longitude;
        double d3 = this.northeast.longitude;
        double d4 = d2 <= d3 ? (d3 + d2) / 2.0 : (d3 + 360.0 + d2) / 2.0;
        return new LatLng(d, d4);
    }

    private static double zzb(double d, double d2) {
        return (d - d2 + 360.0) % 360.0;
    }

    private static double zzc(double d, double d2) {
        return (d2 - d + 360.0) % 360.0;
    }

    private boolean zzh(double d) {
        return this.southwest.latitude <= d && d <= this.northeast.latitude;
    }

    private boolean zzi(double d) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d && d <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d || d <= this.northeast.longitude;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.southwest, this.northeast});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)((Object)object);
        return this.southwest.equals((Object)latLngBounds.southwest) && this.northeast.equals((Object)latLngBounds.northeast);
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("southwest", (Object)this.southwest).zzg("northeast", (Object)this.northeast).toString();
    }

    public static LatLngBounds createFromAttributes(Context context, AttributeSet attributeSet) {
        if (context == null || attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        Float f = null;
        Float f2 = null;
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude)) {
            f = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude)) {
            f2 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude, 0.0f));
        }
        Float f3 = null;
        Float f4 = null;
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude)) {
            f3 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude)) {
            f4 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude, 0.0f));
        }
        if (f == null || f2 == null || f3 == null || f4 == null) {
            return null;
        }
        LatLng latLng = new LatLng(f.floatValue(), f2.floatValue());
        LatLng latLng2 = new LatLng(f3.floatValue(), f4.floatValue());
        return new LatLngBounds(latLng, latLng2);
    }

    public static final class Builder {
        private double zzbpv = Double.POSITIVE_INFINITY;
        private double zzbpw = Double.NEGATIVE_INFINITY;
        private double zzbpx = Double.NaN;
        private double zzbpy = Double.NaN;

        public Builder include(LatLng latLng) {
            this.zzbpv = Math.min(this.zzbpv, latLng.latitude);
            this.zzbpw = Math.max(this.zzbpw, latLng.latitude);
            double d = latLng.longitude;
            if (Double.isNaN(this.zzbpx)) {
                this.zzbpx = d;
                this.zzbpy = d;
            } else if (!this.zzi(d)) {
                if (LatLngBounds.zzb(this.zzbpx, d) < LatLngBounds.zzc(this.zzbpy, d)) {
                    this.zzbpx = d;
                } else {
                    this.zzbpy = d;
                }
            }
            return this;
        }

        private boolean zzi(double d) {
            if (this.zzbpx <= this.zzbpy) {
                return this.zzbpx <= d && d <= this.zzbpy;
            }
            return this.zzbpx <= d || d <= this.zzbpy;
        }

        public LatLngBounds build() {
            zzac.zza((!Double.isNaN(this.zzbpx) ? 1 : 0) != 0, (Object)"no included points");
            return new LatLngBounds(new LatLng(this.zzbpv, this.zzbpx), new LatLng(this.zzbpw, this.zzbpy));
        }
    }
}

