/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.maps.model.zzf;

public final class LatLng
extends zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<LatLng> CREATOR = new zzf();
    public final double latitude;
    public final double longitude;

    public LatLng(double d, double d2) {
        this.longitude = -180.0 <= d2 && d2 < 180.0 ? d2 : ((d2 - 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
        this.latitude = Math.max(-90.0, Math.min(90.0, d));
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LatLng latLng = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (double)latLng.latitude);
        zzd.zza((Parcel)parcel2, (int)3, (double)latLng.longitude);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.latitude);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.longitude);
        return n * 31 + (int)(l ^ l >>> 32);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLng)) {
            return false;
        }
        LatLng latLng = (LatLng)((Object)object);
        return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(latLng.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(latLng.longitude);
    }

    public final String toString() {
        double d = this.latitude;
        double d2 = this.longitude;
        return new StringBuilder(60).append("lat/lng: (").append(d).append(",").append(d2).append(")").toString();
    }
}

