/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolylineOptions
extends zza {
    public static final Parcelable.Creator<PolylineOptions> CREATOR = new zzl();
    private final List<LatLng> zzbnN;
    private float zzbnr = 10.0f;
    private int mColor = -16777216;
    private float zzbnk = 0.0f;
    private boolean zzbnl = true;
    private boolean zzbnP = false;
    private boolean zzbnm = false;
    @NonNull
    private Cap zzbnS = new ButtCap();
    @NonNull
    private Cap zzbnT = new ButtCap();
    private int zzbnU = 0;
    @Nullable
    private List<PatternItem> zzbnV = null;

    public PolylineOptions() {
        this.zzbnN = new ArrayList<LatLng>();
    }

    PolylineOptions(List list, float f, int n, float f2, boolean bl, boolean bl2, boolean bl3, @Nullable Cap cap, @Nullable Cap cap2, int n2, @Nullable List<PatternItem> list2) {
        this.zzbnN = list;
        this.zzbnr = f;
        this.mColor = n;
        this.zzbnk = f2;
        this.zzbnl = bl;
        this.zzbnP = bl2;
        this.zzbnm = bl3;
        if (cap != null) {
            this.zzbnS = cap;
        }
        if (cap2 != null) {
            this.zzbnT = cap2;
        }
        this.zzbnU = n2;
        this.zzbnV = list2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolylineOptions polylineOptions = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)2, polylineOptions.getPoints(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (float)polylineOptions.getWidth());
        zzd.zzc((Parcel)parcel2, (int)4, (int)polylineOptions.getColor());
        zzd.zza((Parcel)parcel2, (int)5, (float)polylineOptions.getZIndex());
        zzd.zza((Parcel)parcel2, (int)6, (boolean)polylineOptions.isVisible());
        zzd.zza((Parcel)parcel2, (int)7, (boolean)polylineOptions.isGeodesic());
        zzd.zza((Parcel)parcel2, (int)8, (boolean)polylineOptions.isClickable());
        zzd.zza((Parcel)parcel2, (int)9, (Parcelable)polylineOptions.getStartCap(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)10, (Parcelable)polylineOptions.getEndCap(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)11, (int)polylineOptions.getJointType());
        zzd.zzc((Parcel)parcel2, (int)12, polylineOptions.getPattern(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final PolylineOptions add(LatLng latLng) {
        this.zzbnN.add(latLng);
        return this;
    }

    public final PolylineOptions add(LatLng ... latLngArray) {
        this.zzbnN.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolylineOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzbnN.add(latLng);
        }
        return this;
    }

    public final PolylineOptions width(float f) {
        this.zzbnr = f;
        return this;
    }

    public final PolylineOptions color(int n) {
        this.mColor = n;
        return this;
    }

    public final PolylineOptions startCap(@NonNull Cap cap) {
        this.zzbnS = (Cap)((Object)zzbo.zzb((Object)((Object)cap), (Object)"startCap must not be null"));
        return this;
    }

    public final PolylineOptions endCap(@NonNull Cap cap) {
        this.zzbnT = (Cap)((Object)zzbo.zzb((Object)((Object)cap), (Object)"endCap must not be null"));
        return this;
    }

    public final PolylineOptions jointType(int n) {
        this.zzbnU = n;
        return this;
    }

    public final PolylineOptions pattern(@Nullable List<PatternItem> list) {
        this.zzbnV = list;
        return this;
    }

    public final PolylineOptions zIndex(float f) {
        this.zzbnk = f;
        return this;
    }

    public final PolylineOptions visible(boolean bl) {
        this.zzbnl = bl;
        return this;
    }

    public final PolylineOptions geodesic(boolean bl) {
        this.zzbnP = bl;
        return this;
    }

    public final PolylineOptions clickable(boolean bl) {
        this.zzbnm = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzbnN;
    }

    public final float getWidth() {
        return this.zzbnr;
    }

    public final int getColor() {
        return this.mColor;
    }

    @NonNull
    public final Cap getStartCap() {
        return this.zzbnS;
    }

    @NonNull
    public final Cap getEndCap() {
        return this.zzbnT;
    }

    public final int getJointType() {
        return this.zzbnU;
    }

    @Nullable
    public final List<PatternItem> getPattern() {
        return this.zzbnV;
    }

    public final float getZIndex() {
        return this.zzbnk;
    }

    public final boolean isVisible() {
        return this.zzbnl;
    }

    public final boolean isGeodesic() {
        return this.zzbnP;
    }

    public final boolean isClickable() {
        return this.zzbnm;
    }
}

