/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.CustomCap;
import com.google.android.gms.maps.model.RoundCap;
import com.google.android.gms.maps.model.SquareCap;
import com.google.android.gms.maps.model.zzb;
import java.util.Arrays;

public class Cap
extends zzbgl {
    private static final String zza = Cap.class.getSimpleName();
    @Hide
    public static final Parcelable.Creator<Cap> CREATOR = new zzb();
    private final int zzb;
    @Nullable
    private final BitmapDescriptor zzc;
    @Nullable
    private final Float zzd;

    private Cap(int n, @Nullable BitmapDescriptor bitmapDescriptor, @Nullable Float f) {
        boolean bl = f != null && f.floatValue() > 0.0f;
        zzbq.zzb((n != 3 || bitmapDescriptor != null && bl ? 1 : 0) != 0, (Object)String.format("Invalid Cap: type=%s bitmapDescriptor=%s bitmapRefWidth=%s", n, bitmapDescriptor, f));
        this.zzb = n;
        this.zzc = bitmapDescriptor;
        this.zzd = f;
    }

    @Hide
    Cap(int n, @Nullable IBinder iBinder, @Nullable Float f) {
        BitmapDescriptor bitmapDescriptor;
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            bitmapDescriptor = null;
        } else {
            IObjectWrapper iObjectWrapper = IObjectWrapper.zza.zza((IBinder)iBinder2);
            bitmapDescriptor = new BitmapDescriptor(iObjectWrapper);
        }
        this(n, bitmapDescriptor, f);
    }

    @Hide
    protected Cap(@NonNull BitmapDescriptor bitmapDescriptor, float f) {
        this(3, bitmapDescriptor, Float.valueOf(f));
    }

    @Hide
    protected Cap(int n) {
        this(n, (BitmapDescriptor)null, (Float)null);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Cap cap = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (int)cap.zzb);
        Cap cap2 = cap;
        zzbgo.zza((Parcel)parcel2, (int)3, cap2.zzc == null ? null : cap2.zzc.zza().asBinder(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Float)cap.zzd, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzb, this.zzc, this.zzd});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cap)) {
            return false;
        }
        Cap cap = (Cap)((Object)object);
        return this.zzb == cap.zzb && zzbg.zza((Object)this.zzc, (Object)cap.zzc) && zzbg.zza((Object)this.zzd, (Object)cap.zzd);
    }

    public String toString() {
        int n = this.zzb;
        return new StringBuilder(23).append("[Cap: type=").append(n).append("]").toString();
    }

    @Hide
    final Cap zza() {
        switch (this.zzb) {
            case 0: {
                return new ButtCap();
            }
            case 1: {
                return new SquareCap();
            }
            case 2: {
                return new RoundCap();
            }
            case 3: {
                return new CustomCap(this.zzc, this.zzd.floatValue());
            }
        }
        int n = this.zzb;
        Log.w((String)zza, (String)new StringBuilder(29).append("Unknown Cap type: ").append(n).toString());
        return this;
    }
}

