/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzaa;

public final class GoogleMapOptions
extends zzbgl
implements ReflectedParcelable {
    @Hide
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new zzaa();
    private Boolean zzjau;
    private Boolean zzjav;
    private int mapType = -1;
    private CameraPosition zzjaw;
    private Boolean zzjax;
    private Boolean zzjay;
    private Boolean zzjaz;
    private Boolean zzjba;
    private Boolean zzjbb;
    private Boolean zzjbc;
    private Boolean zzjbd;
    private Boolean zzjbe;
    private Boolean zzjbf;
    private Float zzjbg = null;
    private Float zzjbh = null;
    private LatLngBounds zzjbi = null;

    @Hide
    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zzjau = zza.zza(by);
        this.zzjav = zza.zza(by2);
        this.mapType = n;
        this.zzjaw = cameraPosition;
        this.zzjax = zza.zza(by3);
        this.zzjay = zza.zza(by4);
        this.zzjaz = zza.zza(by5);
        this.zzjba = zza.zza(by6);
        this.zzjbb = zza.zza(by7);
        this.zzjbc = zza.zza(by8);
        this.zzjbd = zza.zza(by9);
        this.zzjbe = zza.zza(by10);
        this.zzjbf = zza.zza(by11);
        this.zzjbg = f;
        this.zzjbh = f2;
        this.zzjbi = latLngBounds;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleMapOptions googleMapOptions = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (byte)zza.zzc(googleMapOptions.zzjau));
        zzbgo.zza((Parcel)parcel2, (int)3, (byte)zza.zzc(googleMapOptions.zzjav));
        zzbgo.zzc((Parcel)parcel2, (int)4, (int)googleMapOptions.getMapType());
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)googleMapOptions.getCamera(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (byte)zza.zzc(googleMapOptions.zzjax));
        zzbgo.zza((Parcel)parcel2, (int)7, (byte)zza.zzc(googleMapOptions.zzjay));
        zzbgo.zza((Parcel)parcel2, (int)8, (byte)zza.zzc(googleMapOptions.zzjaz));
        zzbgo.zza((Parcel)parcel2, (int)9, (byte)zza.zzc(googleMapOptions.zzjba));
        zzbgo.zza((Parcel)parcel2, (int)10, (byte)zza.zzc(googleMapOptions.zzjbb));
        zzbgo.zza((Parcel)parcel2, (int)11, (byte)zza.zzc(googleMapOptions.zzjbc));
        zzbgo.zza((Parcel)parcel2, (int)12, (byte)zza.zzc(googleMapOptions.zzjbd));
        zzbgo.zza((Parcel)parcel2, (int)14, (byte)zza.zzc(googleMapOptions.zzjbe));
        zzbgo.zza((Parcel)parcel2, (int)15, (byte)zza.zzc(googleMapOptions.zzjbf));
        zzbgo.zza((Parcel)parcel2, (int)16, (Float)googleMapOptions.getMinZoomPreference(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)17, (Float)googleMapOptions.getMaxZoomPreference(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)18, (Parcelable)googleMapOptions.getLatLngBoundsForCameraTarget(), (int)n, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public GoogleMapOptions() {
    }

    public final GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzjau = bl;
        return this;
    }

    public final GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzjav = bl;
        return this;
    }

    public final GoogleMapOptions mapType(int n) {
        this.mapType = n;
        return this;
    }

    public final GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzjaw = cameraPosition;
        return this;
    }

    public final GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzjax = bl;
        return this;
    }

    public final GoogleMapOptions compassEnabled(boolean bl) {
        this.zzjay = bl;
        return this;
    }

    public final GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzjaz = bl;
        return this;
    }

    public final GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzjba = bl;
        return this;
    }

    public final GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzjbb = bl;
        return this;
    }

    public final GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzjbc = bl;
        return this;
    }

    public final GoogleMapOptions liteMode(boolean bl) {
        this.zzjbd = bl;
        return this;
    }

    public final GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzjbe = bl;
        return this;
    }

    public final GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzjbf = bl;
        return this;
    }

    public final GoogleMapOptions minZoomPreference(float f) {
        this.zzjbg = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions maxZoomPreference(float f) {
        this.zzjbh = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzjbi = latLngBounds;
        return this;
    }

    public final Boolean getZOrderOnTop() {
        return this.zzjau;
    }

    public final Boolean getUseViewLifecycleInFragment() {
        return this.zzjav;
    }

    public final int getMapType() {
        return this.mapType;
    }

    public final CameraPosition getCamera() {
        return this.zzjaw;
    }

    public final Boolean getZoomControlsEnabled() {
        return this.zzjax;
    }

    public final Boolean getCompassEnabled() {
        return this.zzjay;
    }

    public final Boolean getScrollGesturesEnabled() {
        return this.zzjaz;
    }

    public final Boolean getZoomGesturesEnabled() {
        return this.zzjba;
    }

    public final Boolean getTiltGesturesEnabled() {
        return this.zzjbb;
    }

    public final Boolean getRotateGesturesEnabled() {
        return this.zzjbc;
    }

    public final Boolean getLiteMode() {
        return this.zzjbd;
    }

    public final Boolean getMapToolbarEnabled() {
        return this.zzjbe;
    }

    public final Boolean getAmbientEnabled() {
        return this.zzjbf;
    }

    public final Float getMinZoomPreference() {
        return this.zzjbg;
    }

    public final Float getMaxZoomPreference() {
        return this.zzjbh;
    }

    public final LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzjbi;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }

    public final String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("MapType", (Object)this.mapType).zzg("LiteMode", (Object)this.zzjbd).zzg("Camera", (Object)this.zzjaw).zzg("CompassEnabled", (Object)this.zzjay).zzg("ZoomControlsEnabled", (Object)this.zzjax).zzg("ScrollGesturesEnabled", (Object)this.zzjaz).zzg("ZoomGesturesEnabled", (Object)this.zzjba).zzg("TiltGesturesEnabled", (Object)this.zzjbb).zzg("RotateGesturesEnabled", (Object)this.zzjbc).zzg("MapToolbarEnabled", (Object)this.zzjbe).zzg("AmbientEnabled", (Object)this.zzjbf).zzg("MinZoomPreference", (Object)this.zzjbg).zzg("MaxZoomPreference", (Object)this.zzjbh).zzg("LatLngBoundsForCameraTarget", (Object)this.zzjbi).zzg("ZOrderOnTop", (Object)this.zzjau).zzg("UseViewLifecycleInFragment", (Object)this.zzjav).toString();
    }
}

