/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.maps.model.IndoorLevel;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.internal.zzj;
import com.google.android.gms.maps.model.internal.zzm;
import com.google.android.gms.maps.model.internal.zzn;
import java.util.ArrayList;
import java.util.List;

public final class IndoorBuilding {
    @NonNull
    private final zzj zzjdl;
    @NonNull
    private final zza zzjdm;

    @Hide
    public IndoorBuilding(@NonNull zzj zzj2) {
        this(zzj2, zza.zzjdn);
    }

    @Hide
    private IndoorBuilding(@NonNull zzj zzj2, @NonNull zza zza2) {
        this.zzjdl = (zzj)zzbq.checkNotNull((Object)zzj2, (Object)"delegate");
        this.zzjdm = (zza)zzbq.checkNotNull((Object)zza2, (Object)"shim");
    }

    public final int getDefaultLevelIndex() {
        try {
            return this.zzjdl.getDefaultLevelIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int getActiveLevelIndex() {
        try {
            return this.zzjdl.getActiveLevelIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final List<IndoorLevel> getLevels() {
        try {
            List<IBinder> list = this.zzjdl.getLevels();
            ArrayList<IndoorLevel> arrayList = new ArrayList<IndoorLevel>(list.size());
            for (IBinder iBinder : list) {
                arrayList.add(zza.zza(zza.zzbg(iBinder)));
            }
            return arrayList;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isUnderground() {
        try {
            return this.zzjdl.isUnderground();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean equals(Object object) {
        if (!(object instanceof IndoorBuilding)) {
            return false;
        }
        try {
            return this.zzjdl.zzb(((IndoorBuilding)object).zzjdl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int hashCode() {
        try {
            return this.zzjdl.hashCodeRemote();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Hide
    static final class zza {
        @Hide
        public static final zza zzjdn = new zza();

        private zza() {
        }

        @Hide
        @NonNull
        public static IndoorLevel zza(@NonNull zzm zzm2) {
            return new IndoorLevel(zzm2);
        }

        @Hide
        @NonNull
        public static zzm zzbg(IBinder iBinder) {
            return zzn.zzbl(iBinder);
        }
    }
}

