/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolylineOptions
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<PolylineOptions> CREATOR = new zzl();
    private final List<LatLng> zzjee;
    private float width = 10.0f;
    private int color = -16777216;
    private float zzjda = 0.0f;
    private boolean zzjdb = true;
    private boolean zzjeg = false;
    private boolean zzjdc = false;
    @NonNull
    private Cap zzjej = new ButtCap();
    @NonNull
    private Cap zzjek = new ButtCap();
    private int zzjel = 0;
    @Nullable
    private List<PatternItem> zzjem = null;

    public PolylineOptions() {
        this.zzjee = new ArrayList<LatLng>();
    }

    @Hide
    PolylineOptions(List list, float f, int n, float f2, boolean bl, boolean bl2, boolean bl3, @Nullable Cap cap, @Nullable Cap cap2, int n2, @Nullable List<PatternItem> list2) {
        this.zzjee = list;
        this.width = f;
        this.color = n;
        this.zzjda = f2;
        this.zzjdb = bl;
        this.zzjeg = bl2;
        this.zzjdc = bl3;
        if (cap != null) {
            this.zzjej = cap;
        }
        if (cap2 != null) {
            this.zzjek = cap2;
        }
        this.zzjel = n2;
        this.zzjem = list2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolylineOptions polylineOptions = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)2, polylineOptions.getPoints(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (float)polylineOptions.getWidth());
        zzbgo.zzc((Parcel)parcel2, (int)4, (int)polylineOptions.getColor());
        zzbgo.zza((Parcel)parcel2, (int)5, (float)polylineOptions.getZIndex());
        zzbgo.zza((Parcel)parcel2, (int)6, (boolean)polylineOptions.isVisible());
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)polylineOptions.isGeodesic());
        zzbgo.zza((Parcel)parcel2, (int)8, (boolean)polylineOptions.isClickable());
        zzbgo.zza((Parcel)parcel2, (int)9, (Parcelable)polylineOptions.getStartCap(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)10, (Parcelable)polylineOptions.getEndCap(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)11, (int)polylineOptions.getJointType());
        zzbgo.zzc((Parcel)parcel2, (int)12, polylineOptions.getPattern(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public final PolylineOptions add(LatLng latLng) {
        this.zzjee.add(latLng);
        return this;
    }

    public final PolylineOptions add(LatLng ... latLngArray) {
        this.zzjee.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolylineOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzjee.add(latLng);
        }
        return this;
    }

    public final PolylineOptions width(float f) {
        this.width = f;
        return this;
    }

    public final PolylineOptions color(int n) {
        this.color = n;
        return this;
    }

    public final PolylineOptions startCap(@NonNull Cap cap) {
        this.zzjej = (Cap)((Object)zzbq.checkNotNull((Object)((Object)cap), (Object)"startCap must not be null"));
        return this;
    }

    public final PolylineOptions endCap(@NonNull Cap cap) {
        this.zzjek = (Cap)((Object)zzbq.checkNotNull((Object)((Object)cap), (Object)"endCap must not be null"));
        return this;
    }

    public final PolylineOptions jointType(int n) {
        this.zzjel = n;
        return this;
    }

    public final PolylineOptions pattern(@Nullable List<PatternItem> list) {
        this.zzjem = list;
        return this;
    }

    public final PolylineOptions zIndex(float f) {
        this.zzjda = f;
        return this;
    }

    public final PolylineOptions visible(boolean bl) {
        this.zzjdb = bl;
        return this;
    }

    public final PolylineOptions geodesic(boolean bl) {
        this.zzjeg = bl;
        return this;
    }

    public final PolylineOptions clickable(boolean bl) {
        this.zzjdc = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzjee;
    }

    public final float getWidth() {
        return this.width;
    }

    public final int getColor() {
        return this.color;
    }

    @NonNull
    public final Cap getStartCap() {
        return this.zzjej;
    }

    @NonNull
    public final Cap getEndCap() {
        return this.zzjek;
    }

    public final int getJointType() {
        return this.zzjel;
    }

    @Nullable
    public final List<PatternItem> getPattern() {
        return this.zzjem;
    }

    public final float getZIndex() {
        return this.zzjda;
    }

    public final boolean isVisible() {
        return this.zzjdb;
    }

    public final boolean isGeodesic() {
        return this.zzjeg;
    }

    public final boolean isClickable() {
        return this.zzjdc;
    }
}

