/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.graphics.Bitmap;
import android.os.RemoteException;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.maps.zze;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public final class BitmapDescriptorFactory {
    public static final float HUE_RED = 0.0f;
    public static final float HUE_ORANGE = 30.0f;
    public static final float HUE_YELLOW = 60.0f;
    public static final float HUE_GREEN = 120.0f;
    public static final float HUE_CYAN = 180.0f;
    public static final float HUE_AZURE = 210.0f;
    public static final float HUE_BLUE = 240.0f;
    public static final float HUE_VIOLET = 270.0f;
    public static final float HUE_MAGENTA = 300.0f;
    public static final float HUE_ROSE = 330.0f;
    private static zze zzcl;

    private BitmapDescriptorFactory() {
    }

    private static zze zzf() {
        return (zze)Preconditions.checkNotNull((Object)zzcl, (Object)"IBitmapDescriptorFactory is not initialized");
    }

    public static void zza(zze zze2) {
        if (zzcl != null) {
            return;
        }
        zzcl = (zze)Preconditions.checkNotNull((Object)zze2);
    }

    public static BitmapDescriptor fromResource(int n) {
        try {
            return new BitmapDescriptor(BitmapDescriptorFactory.zzf().zza(n));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static BitmapDescriptor fromAsset(String string) {
        try {
            return new BitmapDescriptor(BitmapDescriptorFactory.zzf().zza(string));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static BitmapDescriptor fromFile(String string) {
        try {
            return new BitmapDescriptor(BitmapDescriptorFactory.zzf().zzb(string));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static BitmapDescriptor fromPath(String string) {
        try {
            return new BitmapDescriptor(BitmapDescriptorFactory.zzf().zzc(string));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static BitmapDescriptor defaultMarker() {
        try {
            return new BitmapDescriptor(BitmapDescriptorFactory.zzf().zzh());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static BitmapDescriptor defaultMarker(float f) {
        try {
            return new BitmapDescriptor(BitmapDescriptorFactory.zzf().zza(f));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static BitmapDescriptor fromBitmap(Bitmap bitmap) {
        try {
            return new BitmapDescriptor(BitmapDescriptorFactory.zzf().zza(bitmap));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }
}

