/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zza;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="CameraPositionCreator")
public final class CameraPosition
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<CameraPosition> CREATOR = new zza();
    @SafeParcelable.Field(id=2)
    public final LatLng target;
    @SafeParcelable.Field(id=3)
    public final float zoom;
    @SafeParcelable.Field(id=4)
    public final float tilt;
    @SafeParcelable.Field(id=5)
    public final float bearing;

    @SafeParcelable.Constructor
    public CameraPosition(@SafeParcelable.Param(id=2) LatLng latLng, @SafeParcelable.Param(id=3) float f, @SafeParcelable.Param(id=4) float f2, @SafeParcelable.Param(id=5) float f3) {
        Preconditions.checkNotNull((Object)((Object)latLng), (Object)"null camera target");
        Preconditions.checkArgument((0.0f <= f2 && f2 <= 90.0f ? 1 : 0) != 0, (String)"Tilt needs to be between 0 and 90 inclusive: %s", (Object[])new Object[]{Float.valueOf(f2)});
        this.target = latLng;
        this.zoom = f;
        this.tilt = f2 + 0.0f;
        this.bearing = ((double)f3 <= 0.0 ? f3 % 360.0f + 360.0f : f3) % 360.0f;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CameraPosition cameraPosition = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)cameraPosition.target, (int)n, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)3, (float)cameraPosition.zoom);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)4, (float)cameraPosition.tilt);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)5, (float)cameraPosition.bearing);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.target, Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    public static final CameraPosition fromLatLngZoom(LatLng latLng, float f) {
        return new CameraPosition(latLng, f, 0.0f, 0.0f);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition cameraPosition) {
        return new Builder(cameraPosition);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CameraPosition)) {
            return false;
        }
        CameraPosition cameraPosition = (CameraPosition)((Object)object);
        return this.target.equals((Object)cameraPosition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraPosition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraPosition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraPosition.bearing);
    }

    public final String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("target", (Object)this.target).add("zoom", (Object)Float.valueOf(this.zoom)).add("tilt", (Object)Float.valueOf(this.tilt)).add("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static CameraPosition createFromAttributes(Context context, AttributeSet attributeSet) {
        return GoogleMapOptions.zzb(context, attributeSet);
    }

    public static final class Builder {
        private LatLng target;
        private float zoom;
        private float tilt;
        private float bearing;

        public Builder() {
        }

        public Builder(CameraPosition cameraPosition) {
            CameraPosition cameraPosition2 = cameraPosition;
            this.target = cameraPosition2.target;
            this.zoom = cameraPosition2.zoom;
            this.tilt = cameraPosition2.tilt;
            this.bearing = cameraPosition2.bearing;
        }

        public final Builder target(LatLng latLng) {
            this.target = latLng;
            return this;
        }

        public final Builder zoom(float f) {
            this.zoom = f;
            return this;
        }

        public final Builder tilt(float f) {
            this.tilt = f;
            return this;
        }

        public final Builder bearing(float f) {
            this.bearing = f;
            return this;
        }

        public final CameraPosition build() {
            return new CameraPosition(this.target, this.zoom, this.tilt, this.bearing);
        }
    }
}

