/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zze;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="LatLngBoundsCreator")
public final class LatLngBounds
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @KeepForSdk
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new zze();
    @SafeParcelable.Field(id=2)
    public final LatLng southwest;
    @SafeParcelable.Field(id=3)
    public final LatLng northeast;

    @SafeParcelable.Constructor
    public LatLngBounds(@SafeParcelable.Param(id=2) LatLng latLng, @SafeParcelable.Param(id=3) LatLng latLng2) {
        Preconditions.checkNotNull((Object)((Object)latLng), (Object)"null southwest");
        Preconditions.checkNotNull((Object)((Object)latLng2), (Object)"null northeast");
        Preconditions.checkArgument((latLng2.latitude >= latLng.latitude ? 1 : 0) != 0, (String)"southern latitude exceeds northern latitude (%s > %s)", (Object[])new Object[]{latLng.latitude, latLng2.latitude});
        this.southwest = latLng;
        this.northeast = latLng2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LatLngBounds latLngBounds = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)latLngBounds.southwest, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)latLngBounds.northeast, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public final boolean contains(LatLng latLng) {
        LatLngBounds latLngBounds;
        LatLng latLng2 = latLng;
        double d = latLng2.latitude;
        LatLngBounds latLngBounds2 = this;
        return latLngBounds.southwest.latitude <= d && d <= latLngBounds2.northeast.latitude && this.zza(latLng2.longitude);
    }

    public final LatLngBounds including(LatLng latLng) {
        LatLng latLng2 = latLng;
        double d = Math.min(this.southwest.latitude, latLng2.latitude);
        double d2 = Math.max(this.northeast.latitude, latLng2.latitude);
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = latLng2.longitude;
        if (!this.zza(d5)) {
            if (LatLngBounds.zza(d4, d5) < LatLngBounds.zzb(d3, d5)) {
                d4 = d5;
            } else {
                d3 = d5;
            }
        }
        return new LatLngBounds(new LatLng(d, d4), new LatLng(d2, d3));
    }

    public final LatLng getCenter() {
        double d;
        double d2 = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = d <= d3 ? (d3 + d4) / 2.0 : (d3 + 360.0 + d4) / 2.0;
        return new LatLng(d2, d5);
    }

    private static double zza(double d, double d2) {
        return (d - d2 + 360.0) % 360.0;
    }

    private static double zzb(double d, double d2) {
        return (d2 - d + 360.0) % 360.0;
    }

    private final boolean zza(double d) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d && d <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d || d <= this.northeast.longitude;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.southwest, this.northeast});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)((Object)object);
        return this.southwest.equals((Object)latLngBounds.southwest) && this.northeast.equals((Object)latLngBounds.northeast);
    }

    public final String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("southwest", (Object)this.southwest).add("northeast", (Object)this.northeast).toString();
    }

    public static LatLngBounds createFromAttributes(Context context, AttributeSet attributeSet) {
        return GoogleMapOptions.zza(context, attributeSet);
    }

    public static final class Builder {
        private double zzdg = Double.POSITIVE_INFINITY;
        private double zzdh = Double.NEGATIVE_INFINITY;
        private double zzdi = Double.NaN;
        private double zzdj = Double.NaN;

        public Builder() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public final Builder include(LatLng latLng) {
            this.zzdg = Math.min(this.zzdg, latLng.latitude);
            this.zzdh = Math.max(this.zzdh, latLng.latitude);
            double d = latLng.longitude;
            if (Double.isNaN(this.zzdi)) {
                this.zzdi = d;
            } else {
                Builder builder;
                Builder builder2 = this;
                if (builder.zzdi <= builder2.zzdj ? builder2.zzdi <= d && d <= builder2.zzdj : builder2.zzdi <= d || d <= builder2.zzdj) return this;
                if (LatLngBounds.zza(this.zzdi, d) < LatLngBounds.zzb(this.zzdj, d)) {
                    this.zzdi = d;
                    return this;
                }
            }
            this.zzdj = d;
            return this;
        }

        public final LatLngBounds build() {
            Preconditions.checkState((!Double.isNaN(this.zzdi) ? 1 : 0) != 0, (Object)"no included points");
            return new LatLngBounds(new LatLng(this.zzdg, this.zzdi), new LatLng(this.zzdh, this.zzdj));
        }
    }
}

