/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.zzp;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="StreetViewPanoramaOrientationCreator")
public class StreetViewPanoramaOrientation
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<StreetViewPanoramaOrientation> CREATOR = new zzp();
    @SafeParcelable.Field(id=2)
    public final float tilt;
    @SafeParcelable.Field(id=3)
    public final float bearing;

    @SafeParcelable.Constructor
    public StreetViewPanoramaOrientation(@SafeParcelable.Param(id=2) float f, @SafeParcelable.Param(id=3) float f2) {
        Preconditions.checkArgument((-90.0f <= f && f <= 90.0f ? 1 : 0) != 0, (Object)new StringBuilder(62).append("Tilt needs to be between -90 and 90 inclusive: ").append(f).toString());
        this.tilt = f + 0.0f;
        this.bearing = ((double)f2 <= 0.0 ? f2 % 360.0f + 360.0f : f2) % 360.0f;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        StreetViewPanoramaOrientation streetViewPanoramaOrientation = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)2, (float)streetViewPanoramaOrientation.tilt);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)3, (float)streetViewPanoramaOrientation.bearing);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NonNull StreetViewPanoramaOrientation streetViewPanoramaOrientation) {
        return new Builder(streetViewPanoramaOrientation);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StreetViewPanoramaOrientation)) {
            return false;
        }
        StreetViewPanoramaOrientation streetViewPanoramaOrientation = (StreetViewPanoramaOrientation)((Object)object);
        return Float.floatToIntBits(this.tilt) == Float.floatToIntBits(streetViewPanoramaOrientation.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaOrientation.bearing);
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("tilt", (Object)Float.valueOf(this.tilt)).add("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static final class Builder {
        public float bearing;
        public float tilt;

        public Builder() {
        }

        public Builder(@NonNull StreetViewPanoramaOrientation streetViewPanoramaOrientation) {
            Preconditions.checkNotNull((Object)((Object)streetViewPanoramaOrientation), (Object)"StreetViewPanoramaOrientation");
            this.bearing = streetViewPanoramaOrientation.bearing;
            this.tilt = streetViewPanoramaOrientation.tilt;
        }

        public final Builder tilt(float f) {
            this.tilt = f;
            return this;
        }

        public final Builder bearing(float f) {
            this.bearing = f;
            return this;
        }

        public final StreetViewPanoramaOrientation build() {
            return new StreetViewPanoramaOrientation(this.tilt, this.bearing);
        }
    }
}

