/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.maps.zzo;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public final class GroundOverlay {
    private final zzo zza;

    public float getBearing() {
        float f;
        try {
            f = this.zza.zzd();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    public float getHeight() {
        float f;
        try {
            f = this.zza.zze();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    public float getTransparency() {
        float f;
        try {
            f = this.zza.zzf();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    public float getWidth() {
        float f;
        try {
            f = this.zza.zzg();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    public float getZIndex() {
        float f;
        try {
            f = this.zza.zzh();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    public int hashCode() {
        int n;
        try {
            n = this.zza.zzi();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    @NonNull
    public LatLng getPosition() {
        try {
            Object this_ = this_.zza.zzk();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    @NonNull
    public LatLngBounds getBounds() {
        try {
            Object this_ = this_.zza.zzl();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    @Nullable
    public Object getTag() {
        try {
            Object this_ = ObjectWrapper.unwrap((IObjectWrapper)((GroundOverlay)this_).zza.zzj());
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    @NonNull
    public String getId() {
        try {
            String this_ = ((GroundOverlay)((Object)this_)).zza.zzm();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove() {
        try {
            this.zza.zzn();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBearing(float bearing) {
        try {
            void var1_2;
            this.zza.zzo((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClickable(boolean clickable) {
        try {
            void var1_2;
            this.zza.zzp((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDimensions(float width) {
        try {
            void var1_2;
            this.zza.zzq((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDimensions(float width, float height) {
        try {
            void var2_4;
            void var1_2;
            this.zza.zzr((float)var1_2, (float)var2_4);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setImage(@NonNull BitmapDescriptor imageDescriptor) {
        Object object;
        Preconditions.checkNotNull((Object)imageDescriptor, (Object)"imageDescriptor must not be null");
        try {
            object = object.zza();
            this.zza.zzs((IObjectWrapper)object);
            return;
        }
        catch (RemoteException remoteException) {
            object = new RuntimeRemoteException(remoteException);
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPosition(@NonNull LatLng latLng) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            this.zza.zzt((LatLng)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPositionFromBounds(@NonNull LatLngBounds bounds) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            this.zza.zzu((LatLngBounds)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTag(@Nullable Object tag) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            this.zza.zzv(ObjectWrapper.wrap((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTransparency(float transparency) {
        try {
            void var1_2;
            this.zza.zzw((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVisible(boolean visible) {
        try {
            void var1_2;
            this.zza.zzx((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setZIndex(float zIndex) {
        try {
            void var1_2;
            this.zza.zzy((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        RuntimeRemoteException runtimeRemoteException;
        if (!(other instanceof GroundOverlay)) {
            return false;
        }
        try {
            bl = this.zza.zzz(((GroundOverlay)((Object)runtimeRemoteException)).zza);
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    public boolean isClickable() {
        boolean bl;
        try {
            bl = this.zza.zzA();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    public boolean isVisible() {
        boolean bl;
        try {
            bl = this.zza.zzB();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    public GroundOverlay(zzo zzo2) {
        this.zza = (zzo)Preconditions.checkNotNull((Object)zzo2);
    }
}

